@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.GetAccountFilterPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountName The Media Services account name.
 * @property filterName The Account Filter name
 * @property resourceGroupName The name of the resource group within the Azure subscription.
 */
public data class GetAccountFilterPlainArgs(
    public val accountName: String,
    public val filterName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.GetAccountFilterPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.GetAccountFilterPlainArgs =
        com.pulumi.azurenative.media.inputs.GetAccountFilterPlainArgs.builder()
            .accountName(accountName.let({ args0 -> args0 }))
            .filterName(filterName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAccountFilterPlainArgs].
 */
@PulumiTagMarker
public class GetAccountFilterPlainArgsBuilder internal constructor() {
    private var accountName: String? = null

    private var filterName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The Media Services account name.
     */
    @JvmName("qxhnlmkcfladsgrg")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountName = mapped
    }

    /**
     * @param value The Account Filter name
     */
    @JvmName("pbjsvpjkkeeiqrbj")
    public suspend fun filterName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filterName = mapped
    }

    /**
     * @param value The name of the resource group within the Azure subscription.
     */
    @JvmName("myhoraeswcrolvld")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetAccountFilterPlainArgs = GetAccountFilterPlainArgs(
        accountName = accountName ?: throw PulumiNullFieldException("accountName"),
        filterName = filterName ?: throw PulumiNullFieldException("filterName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
