@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.GetAssetEncryptionKeyPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountName The Media Services account name.
 * @property assetName The Asset name.
 * @property resourceGroupName The name of the resource group within the Azure subscription.
 */
public data class GetAssetEncryptionKeyPlainArgs(
    public val accountName: String,
    public val assetName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.GetAssetEncryptionKeyPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.GetAssetEncryptionKeyPlainArgs =
        com.pulumi.azurenative.media.inputs.GetAssetEncryptionKeyPlainArgs.builder()
            .accountName(accountName.let({ args0 -> args0 }))
            .assetName(assetName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAssetEncryptionKeyPlainArgs].
 */
@PulumiTagMarker
public class GetAssetEncryptionKeyPlainArgsBuilder internal constructor() {
    private var accountName: String? = null

    private var assetName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The Media Services account name.
     */
    @JvmName("dvouiglmxefnsfnc")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountName = mapped
    }

    /**
     * @param value The Asset name.
     */
    @JvmName("lwuqaplhnqtqqxkl")
    public suspend fun assetName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.assetName = mapped
    }

    /**
     * @param value The name of the resource group within the Azure subscription.
     */
    @JvmName("quqmhhxqatecvkjp")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetAssetEncryptionKeyPlainArgs = GetAssetEncryptionKeyPlainArgs(
        accountName = accountName ?: throw PulumiNullFieldException("accountName"),
        assetName = assetName ?: throw PulumiNullFieldException("assetName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
