@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.GetPrivateEndpointConnectionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountName The Media Services account name.
 * @property name
 * @property resourceGroupName The name of the resource group within the Azure subscription.
 */
public data class GetPrivateEndpointConnectionPlainArgs(
    public val accountName: String,
    public val name: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.GetPrivateEndpointConnectionPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.GetPrivateEndpointConnectionPlainArgs =
        com.pulumi.azurenative.media.inputs.GetPrivateEndpointConnectionPlainArgs.builder()
            .accountName(accountName.let({ args0 -> args0 }))
            .name(name.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPrivateEndpointConnectionPlainArgs].
 */
@PulumiTagMarker
public class GetPrivateEndpointConnectionPlainArgsBuilder internal constructor() {
    private var accountName: String? = null

    private var name: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The Media Services account name.
     */
    @JvmName("spckcgjsfxvdwyxc")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountName = mapped
    }

    /**
     * @param value
     */
    @JvmName("wcdwosskhcahoiis")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value The name of the resource group within the Azure subscription.
     */
    @JvmName("ubdyelbrbepjnpul")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetPrivateEndpointConnectionPlainArgs =
        GetPrivateEndpointConnectionPlainArgs(
            accountName = accountName ?: throw PulumiNullFieldException("accountName"),
            name = name ?: throw PulumiNullFieldException("name"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
