@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.HlsSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The HLS setting for a track.
 * @property characteristics The characteristics for the HLS setting.
 * @property default The default for the HLS setting.
 * @property forced The forced for the HLS setting.
 */
public data class HlsSettingsArgs(
    public val characteristics: Output<String>? = null,
    public val default: Output<Boolean>? = null,
    public val forced: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.HlsSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.HlsSettingsArgs =
        com.pulumi.azurenative.media.inputs.HlsSettingsArgs.builder()
            .characteristics(characteristics?.applyValue({ args0 -> args0 }))
            .default_(default?.applyValue({ args0 -> args0 }))
            .forced(forced?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HlsSettingsArgs].
 */
@PulumiTagMarker
public class HlsSettingsArgsBuilder internal constructor() {
    private var characteristics: Output<String>? = null

    private var default: Output<Boolean>? = null

    private var forced: Output<Boolean>? = null

    /**
     * @param value The characteristics for the HLS setting.
     */
    @JvmName("wjcsebsmjipaqkck")
    public suspend fun characteristics(`value`: Output<String>) {
        this.characteristics = value
    }

    /**
     * @param value The default for the HLS setting.
     */
    @JvmName("pnijhdlhbvylwnwk")
    public suspend fun default(`value`: Output<Boolean>) {
        this.default = value
    }

    /**
     * @param value The forced for the HLS setting.
     */
    @JvmName("ckbpdghhgnfwoqjg")
    public suspend fun forced(`value`: Output<Boolean>) {
        this.forced = value
    }

    /**
     * @param value The characteristics for the HLS setting.
     */
    @JvmName("ixpapweuehwwruxd")
    public suspend fun characteristics(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.characteristics = mapped
    }

    /**
     * @param value The default for the HLS setting.
     */
    @JvmName("pvdgfggspnfarogp")
    public suspend fun default(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.default = mapped
    }

    /**
     * @param value The forced for the HLS setting.
     */
    @JvmName("mluyiovnjtvfbrby")
    public suspend fun forced(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forced = mapped
    }

    internal fun build(): HlsSettingsArgs = HlsSettingsArgs(
        characteristics = characteristics,
        default = default,
        forced = forced,
    )
}
