@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.IPAccessControlArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The IP access control.
 * @property allow The IP allow list.
 */
public data class IPAccessControlArgs(
    public val allow: Output<List<IPRangeArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.IPAccessControlArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.IPAccessControlArgs =
        com.pulumi.azurenative.media.inputs.IPAccessControlArgs.builder()
            .allow(
                allow?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [IPAccessControlArgs].
 */
@PulumiTagMarker
public class IPAccessControlArgsBuilder internal constructor() {
    private var allow: Output<List<IPRangeArgs>>? = null

    /**
     * @param value The IP allow list.
     */
    @JvmName("cgsryscnhmiodsxm")
    public suspend fun allow(`value`: Output<List<IPRangeArgs>>) {
        this.allow = value
    }

    @JvmName("bliewixlrmhpirim")
    public suspend fun allow(vararg values: Output<IPRangeArgs>) {
        this.allow = Output.all(values.asList())
    }

    /**
     * @param values The IP allow list.
     */
    @JvmName("aunlqnmtqioipqgx")
    public suspend fun allow(values: List<Output<IPRangeArgs>>) {
        this.allow = Output.all(values)
    }

    /**
     * @param value The IP allow list.
     */
    @JvmName("hyftgdfymnvfunwi")
    public suspend fun allow(`value`: List<IPRangeArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allow = mapped
    }

    /**
     * @param argument The IP allow list.
     */
    @JvmName("phwhanxyhvyiejwx")
    public suspend fun allow(argument: List<suspend IPRangeArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { IPRangeArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.allow = mapped
    }

    /**
     * @param argument The IP allow list.
     */
    @JvmName("kggvwyyddrouutvf")
    public suspend fun allow(vararg argument: suspend IPRangeArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { IPRangeArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.allow = mapped
    }

    /**
     * @param argument The IP allow list.
     */
    @JvmName("vsqueytfejlsotab")
    public suspend fun allow(argument: suspend IPRangeArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(IPRangeArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.allow = mapped
    }

    /**
     * @param values The IP allow list.
     */
    @JvmName("xndiwnnvfnppqmgo")
    public suspend fun allow(vararg values: IPRangeArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allow = mapped
    }

    internal fun build(): IPAccessControlArgs = IPAccessControlArgs(
        allow = allow,
    )
}
