@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.InputFileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * An InputDefinition for a single file.  TrackSelections are scoped to the file specified.
 * @property filename Name of the file that this input definition applies to.
 * @property includedTracks The list of TrackDescriptors which define the metadata and selection of tracks in the input.
 * @property odataType The discriminator for derived types.
 * Expected value is '#Microsoft.Media.InputFile'.
 */
public data class InputFileArgs(
    public val filename: Output<String>? = null,
    public val includedTracks: Output<List<Any>>? = null,
    public val odataType: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.InputFileArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.InputFileArgs =
        com.pulumi.azurenative.media.inputs.InputFileArgs.builder()
            .filename(filename?.applyValue({ args0 -> args0 }))
            .includedTracks(includedTracks?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .odataType(odataType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InputFileArgs].
 */
@PulumiTagMarker
public class InputFileArgsBuilder internal constructor() {
    private var filename: Output<String>? = null

    private var includedTracks: Output<List<Any>>? = null

    private var odataType: Output<String>? = null

    /**
     * @param value Name of the file that this input definition applies to.
     */
    @JvmName("regnkxullqxcyvhp")
    public suspend fun filename(`value`: Output<String>) {
        this.filename = value
    }

    /**
     * @param value The list of TrackDescriptors which define the metadata and selection of tracks in the input.
     */
    @JvmName("ifthgnwnbaaaukcy")
    public suspend fun includedTracks(`value`: Output<List<Any>>) {
        this.includedTracks = value
    }

    @JvmName("wslvkvlqoobhuwac")
    public suspend fun includedTracks(vararg values: Output<Any>) {
        this.includedTracks = Output.all(values.asList())
    }

    /**
     * @param values The list of TrackDescriptors which define the metadata and selection of tracks in the input.
     */
    @JvmName("dtsnryrdijskfdwa")
    public suspend fun includedTracks(values: List<Output<Any>>) {
        this.includedTracks = Output.all(values)
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.Media.InputFile'.
     */
    @JvmName("qekvtwfirggmtetr")
    public suspend fun odataType(`value`: Output<String>) {
        this.odataType = value
    }

    /**
     * @param value Name of the file that this input definition applies to.
     */
    @JvmName("eyjfcoiwsdckbuhp")
    public suspend fun filename(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filename = mapped
    }

    /**
     * @param value The list of TrackDescriptors which define the metadata and selection of tracks in the input.
     */
    @JvmName("shkuxkckcgjspysu")
    public suspend fun includedTracks(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.includedTracks = mapped
    }

    /**
     * @param values The list of TrackDescriptors which define the metadata and selection of tracks in the input.
     */
    @JvmName("vubuixygliumfoxq")
    public suspend fun includedTracks(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.includedTracks = mapped
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.Media.InputFile'.
     */
    @JvmName("pjuiifdavbhrdhhj")
    public suspend fun odataType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.odataType = mapped
    }

    internal fun build(): InputFileArgs = InputFileArgs(
        filename = filename,
        includedTracks = includedTracks,
        odataType = odataType ?: throw PulumiNullFieldException("odataType"),
    )
}
