@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.ListAssetContainerSasPlainArgs.builder
import com.pulumi.azurenative.media.kotlin.enums.AssetContainerPermission
import com.pulumi.core.Either
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountName The Media Services account name.
 * @property assetName The Asset name.
 * @property expiryTime The SAS URL expiration time.  This must be less than 24 hours from the current time.
 * @property permissions The permissions to set on the SAS URL.
 * @property resourceGroupName The name of the resource group within the Azure subscription.
 */
public data class ListAssetContainerSasPlainArgs(
    public val accountName: String,
    public val assetName: String,
    public val expiryTime: String? = null,
    public val permissions: Either<String, AssetContainerPermission>? = null,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.ListAssetContainerSasPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.ListAssetContainerSasPlainArgs =
        com.pulumi.azurenative.media.inputs.ListAssetContainerSasPlainArgs.builder()
            .accountName(accountName.let({ args0 -> args0 }))
            .assetName(assetName.let({ args0 -> args0 }))
            .expiryTime(expiryTime?.let({ args0 -> args0 }))
            .permissions(
                permissions?.let({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListAssetContainerSasPlainArgs].
 */
@PulumiTagMarker
public class ListAssetContainerSasPlainArgsBuilder internal constructor() {
    private var accountName: String? = null

    private var assetName: String? = null

    private var expiryTime: String? = null

    private var permissions: Either<String, AssetContainerPermission>? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The Media Services account name.
     */
    @JvmName("jpuohcoqwcwmcuma")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountName = mapped
    }

    /**
     * @param value The Asset name.
     */
    @JvmName("aeqasqrkakywnxyo")
    public suspend fun assetName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.assetName = mapped
    }

    /**
     * @param value The SAS URL expiration time.  This must be less than 24 hours from the current time.
     */
    @JvmName("dfoxprotnhrtogis")
    public suspend fun expiryTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.expiryTime = mapped
    }

    /**
     * @param value The permissions to set on the SAS URL.
     */
    @JvmName("mmkvvwuqvmpelkkx")
    public suspend fun permissions(`value`: Either<String, AssetContainerPermission>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.permissions = mapped
    }

    /**
     * @param value The permissions to set on the SAS URL.
     */
    @JvmName("scqxkmxdspsscvlt")
    public fun permissions(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AssetContainerPermission>(value)
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.permissions = mapped
    }

    /**
     * @param value The permissions to set on the SAS URL.
     */
    @JvmName("rqjatwuallefmcqf")
    public fun permissions(`value`: AssetContainerPermission) {
        val toBeMapped = Either.ofRight<String, AssetContainerPermission>(value)
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.permissions = mapped
    }

    /**
     * @param value The name of the resource group within the Azure subscription.
     */
    @JvmName("wgrjowedcxlhjstq")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): ListAssetContainerSasPlainArgs = ListAssetContainerSasPlainArgs(
        accountName = accountName ?: throw PulumiNullFieldException("accountName"),
        assetName = assetName ?: throw PulumiNullFieldException("assetName"),
        expiryTime = expiryTime,
        permissions = permissions,
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
