@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.ListMediaServiceKeysPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property mediaServiceName Name of the Media Service.
 * @property resourceGroupName Name of the resource group within the Azure subscription.
 */
public data class ListMediaServiceKeysPlainArgs(
    public val mediaServiceName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.ListMediaServiceKeysPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.ListMediaServiceKeysPlainArgs =
        com.pulumi.azurenative.media.inputs.ListMediaServiceKeysPlainArgs.builder()
            .mediaServiceName(mediaServiceName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListMediaServiceKeysPlainArgs].
 */
@PulumiTagMarker
public class ListMediaServiceKeysPlainArgsBuilder internal constructor() {
    private var mediaServiceName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the Media Service.
     */
    @JvmName("ymuyfqgqckjdclim")
    public suspend fun mediaServiceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.mediaServiceName = mapped
    }

    /**
     * @param value Name of the resource group within the Azure subscription.
     */
    @JvmName("rkkjuttbjwtrenwl")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): ListMediaServiceKeysPlainArgs = ListMediaServiceKeysPlainArgs(
        mediaServiceName = mediaServiceName ?: throw PulumiNullFieldException("mediaServiceName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
