@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.LiveEventInputAccessControlArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The IP access control for live event input.
 * @property ip The IP access control properties.
 */
public data class LiveEventInputAccessControlArgs(
    public val ip: Output<IPAccessControlArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.LiveEventInputAccessControlArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.LiveEventInputAccessControlArgs =
        com.pulumi.azurenative.media.inputs.LiveEventInputAccessControlArgs.builder()
            .ip(ip?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [LiveEventInputAccessControlArgs].
 */
@PulumiTagMarker
public class LiveEventInputAccessControlArgsBuilder internal constructor() {
    private var ip: Output<IPAccessControlArgs>? = null

    /**
     * @param value The IP access control properties.
     */
    @JvmName("bemqsqggwpoftsxg")
    public suspend fun ip(`value`: Output<IPAccessControlArgs>) {
        this.ip = value
    }

    /**
     * @param value The IP access control properties.
     */
    @JvmName("gcyprxupswpixtvx")
    public suspend fun ip(`value`: IPAccessControlArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ip = mapped
    }

    /**
     * @param argument The IP access control properties.
     */
    @JvmName("laqphkpflpoaiult")
    public suspend fun ip(argument: suspend IPAccessControlArgsBuilder.() -> Unit) {
        val toBeMapped = IPAccessControlArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.ip = mapped
    }

    internal fun build(): LiveEventInputAccessControlArgs = LiveEventInputAccessControlArgs(
        ip = ip,
    )
}
