@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.RectangleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes the properties of a rectangular window applied to the input media before processing it.
 * @property height The height of the rectangular region in pixels. This can be absolute pixel value (e.g 100), or relative to the size of the video (For example, 50%).
 * @property left The number of pixels from the left-margin. This can be absolute pixel value (e.g 100), or relative to the size of the video (For example, 50%).
 * @property top The number of pixels from the top-margin. This can be absolute pixel value (e.g 100), or relative to the size of the video (For example, 50%).
 * @property width The width of the rectangular region in pixels. This can be absolute pixel value (e.g 100), or relative to the size of the video (For example, 50%).
 */
public data class RectangleArgs(
    public val height: Output<String>? = null,
    public val left: Output<String>? = null,
    public val top: Output<String>? = null,
    public val width: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.RectangleArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.RectangleArgs =
        com.pulumi.azurenative.media.inputs.RectangleArgs.builder()
            .height(height?.applyValue({ args0 -> args0 }))
            .left(left?.applyValue({ args0 -> args0 }))
            .top(top?.applyValue({ args0 -> args0 }))
            .width(width?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RectangleArgs].
 */
@PulumiTagMarker
public class RectangleArgsBuilder internal constructor() {
    private var height: Output<String>? = null

    private var left: Output<String>? = null

    private var top: Output<String>? = null

    private var width: Output<String>? = null

    /**
     * @param value The height of the rectangular region in pixels. This can be absolute pixel value (e.g 100), or relative to the size of the video (For example, 50%).
     */
    @JvmName("utbsoanttwikgbjh")
    public suspend fun height(`value`: Output<String>) {
        this.height = value
    }

    /**
     * @param value The number of pixels from the left-margin. This can be absolute pixel value (e.g 100), or relative to the size of the video (For example, 50%).
     */
    @JvmName("pbcyvkatpcjtighu")
    public suspend fun left(`value`: Output<String>) {
        this.left = value
    }

    /**
     * @param value The number of pixels from the top-margin. This can be absolute pixel value (e.g 100), or relative to the size of the video (For example, 50%).
     */
    @JvmName("rfyrtxlmmypavwye")
    public suspend fun top(`value`: Output<String>) {
        this.top = value
    }

    /**
     * @param value The width of the rectangular region in pixels. This can be absolute pixel value (e.g 100), or relative to the size of the video (For example, 50%).
     */
    @JvmName("lgkxwaghheyskbgb")
    public suspend fun width(`value`: Output<String>) {
        this.width = value
    }

    /**
     * @param value The height of the rectangular region in pixels. This can be absolute pixel value (e.g 100), or relative to the size of the video (For example, 50%).
     */
    @JvmName("dhavxhlfqaamictu")
    public suspend fun height(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.height = mapped
    }

    /**
     * @param value The number of pixels from the left-margin. This can be absolute pixel value (e.g 100), or relative to the size of the video (For example, 50%).
     */
    @JvmName("spubuursovrpggbi")
    public suspend fun left(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.left = mapped
    }

    /**
     * @param value The number of pixels from the top-margin. This can be absolute pixel value (e.g 100), or relative to the size of the video (For example, 50%).
     */
    @JvmName("bifawweyuscnveii")
    public suspend fun top(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.top = mapped
    }

    /**
     * @param value The width of the rectangular region in pixels. This can be absolute pixel value (e.g 100), or relative to the size of the video (For example, 50%).
     */
    @JvmName("lfejyygmjhshhngm")
    public suspend fun width(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.width = mapped
    }

    internal fun build(): RectangleArgs = RectangleArgs(
        height = height,
        left = left,
        top = top,
        width = width,
    )
}
