@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.SelectAudioTrackByIdArgs.builder
import com.pulumi.azurenative.media.kotlin.enums.ChannelMapping
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Select audio tracks from the input by specifying a track identifier.
 * @property channelMapping Optional designation for single channel audio tracks.  Can be used to combine the tracks into stereo or multi-channel audio tracks.
 * @property odataType The discriminator for derived types.
 * Expected value is '#Microsoft.Media.SelectAudioTrackById'.
 * @property trackId Track identifier to select
 */
public data class SelectAudioTrackByIdArgs(
    public val channelMapping: Output<Either<String, ChannelMapping>>? = null,
    public val odataType: Output<String>,
    public val trackId: Output<Double>,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.SelectAudioTrackByIdArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.SelectAudioTrackByIdArgs =
        com.pulumi.azurenative.media.inputs.SelectAudioTrackByIdArgs.builder()
            .channelMapping(
                channelMapping?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .odataType(odataType.applyValue({ args0 -> args0 }))
            .trackId(trackId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SelectAudioTrackByIdArgs].
 */
@PulumiTagMarker
public class SelectAudioTrackByIdArgsBuilder internal constructor() {
    private var channelMapping: Output<Either<String, ChannelMapping>>? = null

    private var odataType: Output<String>? = null

    private var trackId: Output<Double>? = null

    /**
     * @param value Optional designation for single channel audio tracks.  Can be used to combine the tracks into stereo or multi-channel audio tracks.
     */
    @JvmName("hqpjtccmxdqhohgl")
    public suspend fun channelMapping(`value`: Output<Either<String, ChannelMapping>>) {
        this.channelMapping = value
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.Media.SelectAudioTrackById'.
     */
    @JvmName("tnppqpfjsherafay")
    public suspend fun odataType(`value`: Output<String>) {
        this.odataType = value
    }

    /**
     * @param value Track identifier to select
     */
    @JvmName("bciwwreaflhdaoxs")
    public suspend fun trackId(`value`: Output<Double>) {
        this.trackId = value
    }

    /**
     * @param value Optional designation for single channel audio tracks.  Can be used to combine the tracks into stereo or multi-channel audio tracks.
     */
    @JvmName("sjrqopjxyynthwrw")
    public suspend fun channelMapping(`value`: Either<String, ChannelMapping>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.channelMapping = mapped
    }

    /**
     * @param value Optional designation for single channel audio tracks.  Can be used to combine the tracks into stereo or multi-channel audio tracks.
     */
    @JvmName("fgrooaklkeawnyjl")
    public fun channelMapping(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ChannelMapping>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.channelMapping = mapped
    }

    /**
     * @param value Optional designation for single channel audio tracks.  Can be used to combine the tracks into stereo or multi-channel audio tracks.
     */
    @JvmName("eodiyfnnukqrwhsn")
    public fun channelMapping(`value`: ChannelMapping) {
        val toBeMapped = Either.ofRight<String, ChannelMapping>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.channelMapping = mapped
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.Media.SelectAudioTrackById'.
     */
    @JvmName("hwjmpbcutpefhodn")
    public suspend fun odataType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.odataType = mapped
    }

    /**
     * @param value Track identifier to select
     */
    @JvmName("vbgewaguaibfmhta")
    public suspend fun trackId(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.trackId = mapped
    }

    internal fun build(): SelectAudioTrackByIdArgs = SelectAudioTrackByIdArgs(
        channelMapping = channelMapping,
        odataType = odataType ?: throw PulumiNullFieldException("odataType"),
        trackId = trackId ?: throw PulumiNullFieldException("trackId"),
    )
}
