@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.SelectVideoTrackByAttributeArgs.builder
import com.pulumi.azurenative.media.kotlin.enums.AttributeFilter
import com.pulumi.azurenative.media.kotlin.enums.TrackAttribute
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Select video tracks from the input by specifying an attribute and an attribute filter.
 * @property attribute The TrackAttribute to filter the tracks by.
 * @property filter The type of AttributeFilter to apply to the TrackAttribute in order to select the tracks.
 * @property filterValue The value to filter the tracks by.  Only used when AttributeFilter.ValueEquals is specified for the Filter property. For TrackAttribute.Bitrate, this should be an integer value in bits per second (e.g: '1500000').  The TrackAttribute.Language is not supported for video tracks.
 * @property odataType The discriminator for derived types.
 * Expected value is '#Microsoft.Media.SelectVideoTrackByAttribute'.
 */
public data class SelectVideoTrackByAttributeArgs(
    public val attribute: Output<Either<String, TrackAttribute>>,
    public val filter: Output<Either<String, AttributeFilter>>,
    public val filterValue: Output<String>? = null,
    public val odataType: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.SelectVideoTrackByAttributeArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.SelectVideoTrackByAttributeArgs =
        com.pulumi.azurenative.media.inputs.SelectVideoTrackByAttributeArgs.builder()
            .attribute(
                attribute.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .filter(
                filter.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .filterValue(filterValue?.applyValue({ args0 -> args0 }))
            .odataType(odataType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SelectVideoTrackByAttributeArgs].
 */
@PulumiTagMarker
public class SelectVideoTrackByAttributeArgsBuilder internal constructor() {
    private var attribute: Output<Either<String, TrackAttribute>>? = null

    private var filter: Output<Either<String, AttributeFilter>>? = null

    private var filterValue: Output<String>? = null

    private var odataType: Output<String>? = null

    /**
     * @param value The TrackAttribute to filter the tracks by.
     */
    @JvmName("wbkdxhqstijjyugs")
    public suspend fun attribute(`value`: Output<Either<String, TrackAttribute>>) {
        this.attribute = value
    }

    /**
     * @param value The type of AttributeFilter to apply to the TrackAttribute in order to select the tracks.
     */
    @JvmName("bdwekkoliabbpdgp")
    public suspend fun filter(`value`: Output<Either<String, AttributeFilter>>) {
        this.filter = value
    }

    /**
     * @param value The value to filter the tracks by.  Only used when AttributeFilter.ValueEquals is specified for the Filter property. For TrackAttribute.Bitrate, this should be an integer value in bits per second (e.g: '1500000').  The TrackAttribute.Language is not supported for video tracks.
     */
    @JvmName("nhlxdvhqxssluekl")
    public suspend fun filterValue(`value`: Output<String>) {
        this.filterValue = value
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.Media.SelectVideoTrackByAttribute'.
     */
    @JvmName("xxmdpnxyhxkvomiu")
    public suspend fun odataType(`value`: Output<String>) {
        this.odataType = value
    }

    /**
     * @param value The TrackAttribute to filter the tracks by.
     */
    @JvmName("rjtnvlujlfmdqqsh")
    public suspend fun attribute(`value`: Either<String, TrackAttribute>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.attribute = mapped
    }

    /**
     * @param value The TrackAttribute to filter the tracks by.
     */
    @JvmName("dadppdcjstibkehg")
    public fun attribute(`value`: String) {
        val toBeMapped = Either.ofLeft<String, TrackAttribute>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.attribute = mapped
    }

    /**
     * @param value The TrackAttribute to filter the tracks by.
     */
    @JvmName("iwhuwmrgkahteqmt")
    public fun attribute(`value`: TrackAttribute) {
        val toBeMapped = Either.ofRight<String, TrackAttribute>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.attribute = mapped
    }

    /**
     * @param value The type of AttributeFilter to apply to the TrackAttribute in order to select the tracks.
     */
    @JvmName("sqhcyqjssfdiyhcy")
    public suspend fun filter(`value`: Either<String, AttributeFilter>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.filter = mapped
    }

    /**
     * @param value The type of AttributeFilter to apply to the TrackAttribute in order to select the tracks.
     */
    @JvmName("osuavtssxcepotfl")
    public fun filter(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AttributeFilter>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.filter = mapped
    }

    /**
     * @param value The type of AttributeFilter to apply to the TrackAttribute in order to select the tracks.
     */
    @JvmName("tuyjapqvwxtsfwyp")
    public fun filter(`value`: AttributeFilter) {
        val toBeMapped = Either.ofRight<String, AttributeFilter>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.filter = mapped
    }

    /**
     * @param value The value to filter the tracks by.  Only used when AttributeFilter.ValueEquals is specified for the Filter property. For TrackAttribute.Bitrate, this should be an integer value in bits per second (e.g: '1500000').  The TrackAttribute.Language is not supported for video tracks.
     */
    @JvmName("uexbmgebsuydmgst")
    public suspend fun filterValue(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filterValue = mapped
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.Media.SelectVideoTrackByAttribute'.
     */
    @JvmName("nnbgnkjewkrhtdae")
    public suspend fun odataType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.odataType = mapped
    }

    internal fun build(): SelectVideoTrackByAttributeArgs = SelectVideoTrackByAttributeArgs(
        attribute = attribute ?: throw PulumiNullFieldException("attribute"),
        filter = filter ?: throw PulumiNullFieldException("filter"),
        filterValue = filterValue,
        odataType = odataType ?: throw PulumiNullFieldException("odataType"),
    )
}
