@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.StreamingEndpointAccessControlArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Streaming endpoint access control definition.
 * @property akamai The access control of Akamai
 * @property ip The IP access control of the streaming endpoint.
 */
public data class StreamingEndpointAccessControlArgs(
    public val akamai: Output<AkamaiAccessControlArgs>? = null,
    public val ip: Output<IPAccessControlArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.StreamingEndpointAccessControlArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.StreamingEndpointAccessControlArgs =
        com.pulumi.azurenative.media.inputs.StreamingEndpointAccessControlArgs.builder()
            .akamai(akamai?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .ip(ip?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [StreamingEndpointAccessControlArgs].
 */
@PulumiTagMarker
public class StreamingEndpointAccessControlArgsBuilder internal constructor() {
    private var akamai: Output<AkamaiAccessControlArgs>? = null

    private var ip: Output<IPAccessControlArgs>? = null

    /**
     * @param value The access control of Akamai
     */
    @JvmName("sqarnhquyujelugy")
    public suspend fun akamai(`value`: Output<AkamaiAccessControlArgs>) {
        this.akamai = value
    }

    /**
     * @param value The IP access control of the streaming endpoint.
     */
    @JvmName("kqbbqfvwjlqtqdcr")
    public suspend fun ip(`value`: Output<IPAccessControlArgs>) {
        this.ip = value
    }

    /**
     * @param value The access control of Akamai
     */
    @JvmName("lucwhjfojgebspxl")
    public suspend fun akamai(`value`: AkamaiAccessControlArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.akamai = mapped
    }

    /**
     * @param argument The access control of Akamai
     */
    @JvmName("gvdicdwtcnfjcybe")
    public suspend fun akamai(argument: suspend AkamaiAccessControlArgsBuilder.() -> Unit) {
        val toBeMapped = AkamaiAccessControlArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.akamai = mapped
    }

    /**
     * @param value The IP access control of the streaming endpoint.
     */
    @JvmName("dvpwyqeqpnmokwmd")
    public suspend fun ip(`value`: IPAccessControlArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ip = mapped
    }

    /**
     * @param argument The IP access control of the streaming endpoint.
     */
    @JvmName("pypwcpjnulbjlgya")
    public suspend fun ip(argument: suspend IPAccessControlArgsBuilder.() -> Unit) {
        val toBeMapped = IPAccessControlArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.ip = mapped
    }

    internal fun build(): StreamingEndpointAccessControlArgs = StreamingEndpointAccessControlArgs(
        akamai = akamai,
        ip = ip,
    )
}
