@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.StreamingPolicyContentKeyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Class to specify properties of content key
 * @property label Label can be used to specify Content Key when creating a Streaming Locator
 * @property policyName Policy used by Content Key
 * @property tracks Tracks which use this content key
 */
public data class StreamingPolicyContentKeyArgs(
    public val label: Output<String>? = null,
    public val policyName: Output<String>? = null,
    public val tracks: Output<List<TrackSelectionArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.StreamingPolicyContentKeyArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.StreamingPolicyContentKeyArgs =
        com.pulumi.azurenative.media.inputs.StreamingPolicyContentKeyArgs.builder()
            .label(label?.applyValue({ args0 -> args0 }))
            .policyName(policyName?.applyValue({ args0 -> args0 }))
            .tracks(
                tracks?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [StreamingPolicyContentKeyArgs].
 */
@PulumiTagMarker
public class StreamingPolicyContentKeyArgsBuilder internal constructor() {
    private var label: Output<String>? = null

    private var policyName: Output<String>? = null

    private var tracks: Output<List<TrackSelectionArgs>>? = null

    /**
     * @param value Label can be used to specify Content Key when creating a Streaming Locator
     */
    @JvmName("srworjxapkwtlkmn")
    public suspend fun label(`value`: Output<String>) {
        this.label = value
    }

    /**
     * @param value Policy used by Content Key
     */
    @JvmName("ucldlrsumpfyardc")
    public suspend fun policyName(`value`: Output<String>) {
        this.policyName = value
    }

    /**
     * @param value Tracks which use this content key
     */
    @JvmName("xujsxuqekugsliam")
    public suspend fun tracks(`value`: Output<List<TrackSelectionArgs>>) {
        this.tracks = value
    }

    @JvmName("vcyxcahhnooudfyd")
    public suspend fun tracks(vararg values: Output<TrackSelectionArgs>) {
        this.tracks = Output.all(values.asList())
    }

    /**
     * @param values Tracks which use this content key
     */
    @JvmName("bwxckaheseminjdb")
    public suspend fun tracks(values: List<Output<TrackSelectionArgs>>) {
        this.tracks = Output.all(values)
    }

    /**
     * @param value Label can be used to specify Content Key when creating a Streaming Locator
     */
    @JvmName("yopmxfgswmsbyoqq")
    public suspend fun label(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.label = mapped
    }

    /**
     * @param value Policy used by Content Key
     */
    @JvmName("stluuwktvxaawask")
    public suspend fun policyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyName = mapped
    }

    /**
     * @param value Tracks which use this content key
     */
    @JvmName("hwoijlxlhvhpcrmt")
    public suspend fun tracks(`value`: List<TrackSelectionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tracks = mapped
    }

    /**
     * @param argument Tracks which use this content key
     */
    @JvmName("ckeitagsdhfesvac")
    public suspend fun tracks(argument: List<suspend TrackSelectionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TrackSelectionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.tracks = mapped
    }

    /**
     * @param argument Tracks which use this content key
     */
    @JvmName("muorcwifanqvjxci")
    public suspend fun tracks(vararg argument: suspend TrackSelectionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            TrackSelectionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.tracks = mapped
    }

    /**
     * @param argument Tracks which use this content key
     */
    @JvmName("edwtulgppwaoibmg")
    public suspend fun tracks(argument: suspend TrackSelectionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(TrackSelectionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.tracks = mapped
    }

    /**
     * @param values Tracks which use this content key
     */
    @JvmName("ywdwomrnfequqdcp")
    public suspend fun tracks(vararg values: TrackSelectionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tracks = mapped
    }

    internal fun build(): StreamingPolicyContentKeyArgs = StreamingPolicyContentKeyArgs(
        label = label,
        policyName = policyName,
        tracks = tracks,
    )
}
