@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.TrackPropertyConditionArgs.builder
import com.pulumi.azurenative.media.kotlin.enums.TrackPropertyCompareOperation
import com.pulumi.azurenative.media.kotlin.enums.TrackPropertyType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Class to specify one track property condition
 * @property operation Track property condition operation
 * @property property Track property type
 * @property value Track property value
 */
public data class TrackPropertyConditionArgs(
    public val operation: Output<Either<String, TrackPropertyCompareOperation>>,
    public val `property`: Output<Either<String, TrackPropertyType>>,
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.TrackPropertyConditionArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.TrackPropertyConditionArgs =
        com.pulumi.azurenative.media.inputs.TrackPropertyConditionArgs.builder()
            .operation(
                operation.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .`property`(
                `property`.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TrackPropertyConditionArgs].
 */
@PulumiTagMarker
public class TrackPropertyConditionArgsBuilder internal constructor() {
    private var operation: Output<Either<String, TrackPropertyCompareOperation>>? = null

    private var `property`: Output<Either<String, TrackPropertyType>>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value Track property condition operation
     */
    @JvmName("kwumnrxoekoxryyp")
    public suspend fun operation(`value`: Output<Either<String, TrackPropertyCompareOperation>>) {
        this.operation = value
    }

    /**
     * @param value Track property type
     */
    @JvmName("qpabhqruhwfatajx")
    public suspend fun `property`(`value`: Output<Either<String, TrackPropertyType>>) {
        this.`property` = value
    }

    /**
     * @param value Track property value
     */
    @JvmName("agggaywulbudigpb")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Track property condition operation
     */
    @JvmName("qqmwfrhusqxrpatx")
    public suspend fun operation(`value`: Either<String, TrackPropertyCompareOperation>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.operation = mapped
    }

    /**
     * @param value Track property condition operation
     */
    @JvmName("orcbrlvnbuyhyhcv")
    public fun operation(`value`: String) {
        val toBeMapped = Either.ofLeft<String, TrackPropertyCompareOperation>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.operation = mapped
    }

    /**
     * @param value Track property condition operation
     */
    @JvmName("vstijssbcuvnywot")
    public fun operation(`value`: TrackPropertyCompareOperation) {
        val toBeMapped = Either.ofRight<String, TrackPropertyCompareOperation>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.operation = mapped
    }

    /**
     * @param value Track property type
     */
    @JvmName("kldpkesknncdckqa")
    public suspend fun `property`(`value`: Either<String, TrackPropertyType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`property` = mapped
    }

    /**
     * @param value Track property type
     */
    @JvmName("jognfnjodfuxwqtv")
    public fun `property`(`value`: String) {
        val toBeMapped = Either.ofLeft<String, TrackPropertyType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`property` = mapped
    }

    /**
     * @param value Track property type
     */
    @JvmName("iueuswwywdyahhgk")
    public fun `property`(`value`: TrackPropertyType) {
        val toBeMapped = Either.ofRight<String, TrackPropertyType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`property` = mapped
    }

    /**
     * @param value Track property value
     */
    @JvmName("dfkvnggcrvilsvim")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): TrackPropertyConditionArgs = TrackPropertyConditionArgs(
        operation = operation ?: throw PulumiNullFieldException("operation"),
        `property` = `property` ?: throw PulumiNullFieldException("property"),
        `value` = `value`,
    )
}
