@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The Asset File Storage encryption metadata.
 * @property assetFileId The Asset File Id.
 * @property assetFileName The Asset File name.
 * @property initializationVector The Asset File initialization vector.
 */
public data class AssetFileEncryptionMetadataResponse(
    public val assetFileId: String,
    public val assetFileName: String? = null,
    public val initializationVector: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.AssetFileEncryptionMetadataResponse):
            AssetFileEncryptionMetadataResponse = AssetFileEncryptionMetadataResponse(
            assetFileId = javaType.assetFileId(),
            assetFileName = javaType.assetFileName().map({ args0 -> args0 }).orElse(null),
            initializationVector = javaType.initializationVector().map({ args0 -> args0 }).orElse(null),
        )
    }
}
