@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Properties of the Streaming Locator.
 * @property assetName Asset Name.
 * @property created The creation time of the Streaming Locator.
 * @property defaultContentKeyPolicyName Name of the default ContentKeyPolicy used by this Streaming Locator.
 * @property endTime The end time of the Streaming Locator.
 * @property name Streaming Locator name.
 * @property startTime The start time of the Streaming Locator.
 * @property streamingLocatorId StreamingLocatorId of the Streaming Locator.
 * @property streamingPolicyName Name of the Streaming Policy used by this Streaming Locator.
 */
public data class AssetStreamingLocatorResponse(
    public val assetName: String,
    public val created: String,
    public val defaultContentKeyPolicyName: String,
    public val endTime: String,
    public val name: String,
    public val startTime: String,
    public val streamingLocatorId: String,
    public val streamingPolicyName: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.AssetStreamingLocatorResponse):
            AssetStreamingLocatorResponse = AssetStreamingLocatorResponse(
            assetName = javaType.assetName(),
            created = javaType.created(),
            defaultContentKeyPolicyName = javaType.defaultContentKeyPolicyName(),
            endTime = javaType.endTime(),
            name = javaType.name(),
            startTime = javaType.startTime(),
            streamingLocatorId = javaType.streamingLocatorId(),
            streamingPolicyName = javaType.streamingPolicyName(),
        )
    }
}
