@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.Suppress

/**
 * Class to specify DRM configurations of CommonEncryptionCenc scheme in Streaming Policy
 * @property playReady PlayReady configurations
 * @property widevine Widevine configurations
 */
public data class CencDrmConfigurationResponse(
    public val playReady: StreamingPolicyPlayReadyConfigurationResponse? = null,
    public val widevine: StreamingPolicyWidevineConfigurationResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.CencDrmConfigurationResponse):
            CencDrmConfigurationResponse = CencDrmConfigurationResponse(
            playReady = javaType.playReady().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.media.kotlin.outputs.StreamingPolicyPlayReadyConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            widevine = javaType.widevine().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.media.kotlin.outputs.StreamingPolicyWidevineConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
