@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Represents an open restriction. License or key will be delivered on every request.
 * @property odataType The discriminator for derived types.
 * Expected value is '#Microsoft.Media.ContentKeyPolicyOpenRestriction'.
 */
public data class ContentKeyPolicyOpenRestrictionResponse(
    public val odataType: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.ContentKeyPolicyOpenRestrictionResponse):
            ContentKeyPolicyOpenRestrictionResponse = ContentKeyPolicyOpenRestrictionResponse(
            odataType = javaType.odataType(),
        )
    }
}
