@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress

/**
 * Configures the Explicit Analog Television Output Restriction control bits. For further details see the PlayReady Compliance Rules.
 * @property bestEffort Indicates whether this restriction is enforced on a Best Effort basis.
 * @property configurationData Configures the restriction control bits. Must be between 0 and 3 inclusive.
 */
public data class ContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestrictionResponse(
    public val bestEffort: Boolean,
    public val configurationData: Int,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.ContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestrictionResponse):
            ContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestrictionResponse =
            ContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestrictionResponse(
                bestEffort = javaType.bestEffort(),
                configurationData = javaType.configurationData(),
            )
    }
}
