@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Represents a token claim.
 * @property claimType Token claim type.
 * @property claimValue Token claim value.
 */
public data class ContentKeyPolicyTokenClaimResponse(
    public val claimType: String? = null,
    public val claimValue: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.ContentKeyPolicyTokenClaimResponse):
            ContentKeyPolicyTokenClaimResponse = ContentKeyPolicyTokenClaimResponse(
            claimType = javaType.claimType().map({ args0 -> args0 }).orElse(null),
            claimValue = javaType.claimValue().map({ args0 -> args0 }).orElse(null),
        )
    }
}
