@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Class to specify properties of default content key for each encryption scheme
 * @property label Label can be used to specify Content Key when creating a Streaming Locator
 * @property policyName Policy used by Default Key
 */
public data class DefaultKeyResponse(
    public val label: String? = null,
    public val policyName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.DefaultKeyResponse):
            DefaultKeyResponse = DefaultKeyResponse(
            label = javaType.label().map({ args0 -> args0 }).orElse(null),
            policyName = javaType.policyName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
