@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A Media Services account.
 * @property encryption The account encryption properties.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property identity The Managed Identity for the Media Services account.
 * @property keyDelivery The Key Delivery properties for Media Services account.
 * @property location The geo-location where the resource lives
 * @property mediaServiceId The Media Services account ID.
 * @property minimumTlsVersion The minimum TLS version allowed for this account's requests. This is an optional property. If unspecified, a secure default value will be used.
 * @property name The name of the resource
 * @property privateEndpointConnections The Private Endpoint Connections created for the Media Service account.
 * @property provisioningState Provisioning state of the Media Services account.
 * @property publicNetworkAccess Whether or not public network access is allowed for resources under the Media Services account.
 * @property storageAccounts The storage accounts for this resource.
 * @property storageAuthentication
 * @property systemData The system metadata relating to this resource.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetMediaServiceResult(
    public val encryption: AccountEncryptionResponse? = null,
    public val id: String,
    public val identity: MediaServiceIdentityResponse? = null,
    public val keyDelivery: KeyDeliveryResponse? = null,
    public val location: String,
    public val mediaServiceId: String,
    public val minimumTlsVersion: String? = null,
    public val name: String,
    public val privateEndpointConnections: List<PrivateEndpointConnectionResponse>,
    public val provisioningState: String,
    public val publicNetworkAccess: String? = null,
    public val storageAccounts: List<StorageAccountResponse>? = null,
    public val storageAuthentication: String? = null,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.GetMediaServiceResult):
            GetMediaServiceResult = GetMediaServiceResult(
            encryption = javaType.encryption().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.media.kotlin.outputs.AccountEncryptionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.media.kotlin.outputs.MediaServiceIdentityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            keyDelivery = javaType.keyDelivery().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.media.kotlin.outputs.KeyDeliveryResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            location = javaType.location(),
            mediaServiceId = javaType.mediaServiceId(),
            minimumTlsVersion = javaType.minimumTlsVersion().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            privateEndpointConnections = javaType.privateEndpointConnections().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.media.kotlin.outputs.PrivateEndpointConnectionResponse.Companion.toKotlin(args0)
                })
            }),
            provisioningState = javaType.provisioningState(),
            publicNetworkAccess = javaType.publicNetworkAccess().map({ args0 -> args0 }).orElse(null),
            storageAccounts = javaType.storageAccounts().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.media.kotlin.outputs.StorageAccountResponse.Companion.toKotlin(args0)
                })
            }),
            storageAuthentication = javaType.storageAuthentication().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.media.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
