@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 * HTTP Live Streaming (HLS) packing setting for the live output.
 * @property fragmentsPerTsSegment The number of fragments in an HTTP Live Streaming (HLS) TS segment in the output of the live event. This value does not affect the packing ratio for HLS CMAF output.
 */
public data class HlsResponse(
    public val fragmentsPerTsSegment: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.HlsResponse): HlsResponse =
            HlsResponse(
                fragmentsPerTsSegment = javaType.fragmentsPerTsSegment().map({ args0 -> args0 }).orElse(null),
            )
    }
}
