@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The Asset Storage container SAS URLs.
 * @property assetContainerSasUrls The list of Asset container SAS URLs.
 */
public data class ListAssetContainerSasResult(
    public val assetContainerSasUrls: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.ListAssetContainerSasResult):
            ListAssetContainerSasResult = ListAssetContainerSasResult(
            assetContainerSasUrls = javaType.assetContainerSasUrls().map({ args0 -> args0 }),
        )
    }
}
