@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The response body for a ListKeys API.
 * @property primaryAuthEndpoint The primary authorization endpoint.
 * @property primaryKey The primary key for the Media Service resource.
 * @property scope The authorization scope.
 * @property secondaryAuthEndpoint The secondary authorization endpoint.
 * @property secondaryKey The secondary key for the Media Service resource.
 */
public data class ListMediaServiceKeysResult(
    public val primaryAuthEndpoint: String? = null,
    public val primaryKey: String? = null,
    public val scope: String? = null,
    public val secondaryAuthEndpoint: String? = null,
    public val secondaryKey: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.ListMediaServiceKeysResult):
            ListMediaServiceKeysResult = ListMediaServiceKeysResult(
            primaryAuthEndpoint = javaType.primaryAuthEndpoint().map({ args0 -> args0 }).orElse(null),
            primaryKey = javaType.primaryKey().map({ args0 -> args0 }).orElse(null),
            scope = javaType.scope().map({ args0 -> args0 }).orElse(null),
            secondaryAuthEndpoint = javaType.secondaryAuthEndpoint().map({ args0 -> args0 }).orElse(null),
            secondaryKey = javaType.secondaryKey().map({ args0 -> args0 }).orElse(null),
        )
    }
}
