@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * Class of response for listContentKeys action
 * @property contentKeys ContentKeys used by current Streaming Locator
 */
public data class ListStreamingLocatorContentKeysResult(
    public val contentKeys: List<StreamingLocatorContentKeyResponse>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.ListStreamingLocatorContentKeysResult):
            ListStreamingLocatorContentKeysResult = ListStreamingLocatorContentKeysResult(
            contentKeys = javaType.contentKeys().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.media.kotlin.outputs.StreamingLocatorContentKeyResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
