@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A track selection condition. This property is reserved for future use, any value set on this property will be ignored.
 * @property operation Comparing operation. This property is reserved for future use, any value set on this property will be ignored.
 * @property property Property name to select. This property is reserved for future use, any value set on this property will be ignored.
 * @property value Property value to select. This property is reserved for future use, any value set on this property will be ignored.
 */
public data class LiveEventInputTrackSelectionResponse(
    public val operation: String? = null,
    public val `property`: String? = null,
    public val `value`: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.LiveEventInputTrackSelectionResponse):
            LiveEventInputTrackSelectionResponse = LiveEventInputTrackSelectionResponse(
            operation = javaType.operation().map({ args0 -> args0 }).orElse(null),
            `property` = javaType.`property`().map({ args0 -> args0 }).orElse(null),
            `value` = javaType.`value`().map({ args0 -> args0 }).orElse(null),
        )
    }
}
