@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * The live event track ingest heart beat event data.
 * @property bitrate Bitrate of the track.
 * @property discontinuityCount Number of discontinuities detected in the last 20 seconds.
 * @property healthy Indicates whether ingest is healthy.
 * @property incomingBitrate Calculated bitrate based on data chunks coming from encoder.
 * @property ingestDriftValue Indicates the speed of delay, in seconds-per-minute, of the incoming audio or video data during the last minute. The value is greater than zero if data is arriving to the live event slower than expected in the last minute; zero if data arrived with no delay; and "n/a" if no audio or video data was received. For example, if you have a contribution encoder sending in live content, and it is slowing down due to processing issues, or network latency, it may be only able to deliver a total of 58 seconds of audio or video in a one-minute period. This would be reported as two seconds-per-minute of drift. If the encoder is able to catch up and send all 60 seconds or more of data every minute, you will see this value reported as 0. If there was a disconnection or discontinuity from the encoder, this value may still display as 0, as it does not account for breaks in the data - only data that is delayed in timestamps.
 * @property lastFragmentArrivalTime The last timestamp in UTC that a fragment arrived at the ingest endpoint.
 * @property lastTimestamp Latest timestamp received for a track in last 20 seconds.
 * @property nonincreasingCount Number of data chunks with timestamps in the past that were received in last 20 seconds.
 * @property overlapCount Number of data chunks that had overlapped timestamps in last 20 seconds.
 * @property state State of the live event.
 * @property timescale Timescale in which timestamps are expressed.
 * @property trackName Name of the track.
 * @property trackType Type of the track.
 * @property transcriptionLanguage The language code (in BCP-47 format) of the transcription language. For example, "de-de" indicates German (Germany). The value is empty for the video track heartbeats, or when live transcription is turned off.
 * @property transcriptionState This value is "On" for audio track heartbeats if live transcription is turned on, otherwise you will see an empty string. This state is only applicable to track type of "audio" for Live transcription. All other tracks will have an empty value.
 * @property unexpectedBitrate If expected and actual bitrates differ by more than allowed limit in last 20 seconds.
 */
public data class LiveEventTrackEventDataResponse(
    public val bitrate: Double? = null,
    public val discontinuityCount: Double? = null,
    public val healthy: Boolean? = null,
    public val incomingBitrate: Double? = null,
    public val ingestDriftValue: String? = null,
    public val lastFragmentArrivalTime: String? = null,
    public val lastTimestamp: String? = null,
    public val nonincreasingCount: Double? = null,
    public val overlapCount: Double? = null,
    public val state: String? = null,
    public val timescale: String? = null,
    public val trackName: String? = null,
    public val trackType: String? = null,
    public val transcriptionLanguage: String? = null,
    public val transcriptionState: String? = null,
    public val unexpectedBitrate: Boolean? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.LiveEventTrackEventDataResponse):
            LiveEventTrackEventDataResponse = LiveEventTrackEventDataResponse(
            bitrate = javaType.bitrate().map({ args0 -> args0 }).orElse(null),
            discontinuityCount = javaType.discontinuityCount().map({ args0 -> args0 }).orElse(null),
            healthy = javaType.healthy().map({ args0 -> args0 }).orElse(null),
            incomingBitrate = javaType.incomingBitrate().map({ args0 -> args0 }).orElse(null),
            ingestDriftValue = javaType.ingestDriftValue().map({ args0 -> args0 }).orElse(null),
            lastFragmentArrivalTime = javaType.lastFragmentArrivalTime().map({ args0 -> args0 }).orElse(null),
            lastTimestamp = javaType.lastTimestamp().map({ args0 -> args0 }).orElse(null),
            nonincreasingCount = javaType.nonincreasingCount().map({ args0 -> args0 }).orElse(null),
            overlapCount = javaType.overlapCount().map({ args0 -> args0 }).orElse(null),
            state = javaType.state().map({ args0 -> args0 }).orElse(null),
            timescale = javaType.timescale().map({ args0 -> args0 }).orElse(null),
            trackName = javaType.trackName().map({ args0 -> args0 }).orElse(null),
            trackType = javaType.trackType().map({ args0 -> args0 }).orElse(null),
            transcriptionLanguage = javaType.transcriptionLanguage().map({ args0 -> args0 }).orElse(null),
            transcriptionState = javaType.transcriptionState().map({ args0 -> args0 }).orElse(null),
            unexpectedBitrate = javaType.unexpectedBitrate().map({ args0 -> args0 }).orElse(null),
        )
    }
}
