@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Asset sink.
 * @property assetName Asset name.
 * @property inputs Sink inputs.
 * @property name Sink name.
 * @property odataType The discriminator for derived types.
 * Expected value is '#Microsoft.Media.MediaGraphAssetSink'.
 */
public data class MediaGraphAssetSinkResponse(
    public val assetName: String,
    public val inputs: List<String>,
    public val name: String,
    public val odataType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.MediaGraphAssetSinkResponse):
            MediaGraphAssetSinkResponse = MediaGraphAssetSinkResponse(
            assetName = javaType.assetName(),
            inputs = javaType.inputs().map({ args0 -> args0 }),
            name = javaType.name(),
            odataType = javaType.odataType(),
        )
    }
}
