@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Describes the settings to produce a PNG image from the input video.
 * @property height The height of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example 50% means the output video has half as many pixels in height as the input.
 * @property label The alphanumeric label for this layer, which can be used in multiplexing different video and audio layers, or in naming the output file.
 * @property width The width of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example 50% means the output video has half as many pixels in width as the input.
 */
public data class PngLayerResponse(
    public val height: String? = null,
    public val label: String? = null,
    public val width: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.PngLayerResponse):
            PngLayerResponse = PngLayerResponse(
            height = javaType.height().map({ args0 -> args0 }).orElse(null),
            label = javaType.label().map({ args0 -> args0 }).orElse(null),
            width = javaType.width().map({ args0 -> args0 }).orElse(null),
        )
    }
}
