@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Class for content key in Streaming Locator
 * @property id ID of Content Key
 * @property labelReferenceInStreamingPolicy Label of Content Key as specified in the Streaming Policy
 * @property policyName ContentKeyPolicy used by Content Key
 * @property tracks Tracks which use this Content Key
 * @property type Encryption type of Content Key
 * @property value Value of Content Key
 */
public data class StreamingLocatorContentKeyResponse(
    public val id: String,
    public val labelReferenceInStreamingPolicy: String? = null,
    public val policyName: String,
    public val tracks: List<TrackSelectionResponse>,
    public val type: String,
    public val `value`: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.StreamingLocatorContentKeyResponse):
            StreamingLocatorContentKeyResponse = StreamingLocatorContentKeyResponse(
            id = javaType.id(),
            labelReferenceInStreamingPolicy = javaType.labelReferenceInStreamingPolicy().map({ args0 ->
                args0
            }).orElse(null),
            policyName = javaType.policyName(),
            tracks = javaType.tracks().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.media.kotlin.outputs.TrackSelectionResponse.Companion.toKotlin(args0)
                })
            }),
            type = javaType.type(),
            `value` = javaType.`value`().map({ args0 -> args0 }).orElse(null),
        )
    }
}
