@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Class of paths for streaming
 * @property encryptionScheme Encryption scheme
 * @property paths Streaming paths for each protocol and encryptionScheme pair
 * @property streamingProtocol Streaming protocol
 */
public data class StreamingPathResponse(
    public val encryptionScheme: String,
    public val paths: List<String>? = null,
    public val streamingProtocol: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.StreamingPathResponse):
            StreamingPathResponse = StreamingPathResponse(
            encryptionScheme = javaType.encryptionScheme(),
            paths = javaType.paths().map({ args0 -> args0 }),
            streamingProtocol = javaType.streamingProtocol(),
        )
    }
}
