@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin

import com.pulumi.azurenative.migrate.kotlin.outputs.PrivateEndpointConnectionResponse
import com.pulumi.azurenative.migrate.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.migrate.kotlin.outputs.PrivateEndpointConnectionResponse.Companion.toKotlin as privateEndpointConnectionResponseToKotlin
import com.pulumi.azurenative.migrate.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [AssessmentProjectsOperation].
 */
@PulumiTagMarker
public class AssessmentProjectsOperationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AssessmentProjectsOperationArgs = AssessmentProjectsOperationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AssessmentProjectsOperationArgsBuilder.() -> Unit) {
        val builder = AssessmentProjectsOperationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): AssessmentProjectsOperation {
        val builtJavaResource =
            com.pulumi.azurenative.migrate.AssessmentProjectsOperation(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return AssessmentProjectsOperation(builtJavaResource)
    }
}

/**
 * An Assessment project site resource.
 * Azure REST API version: 2023-03-15.
 * ## Example Usage
 * ### AssessmentProjectsOperations_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var assessmentProjectsOperation = new AzureNative.Migrate.AssessmentProjectsOperation("assessmentProjectsOperation", new()
 *     {
 *         AssessmentSolutionId = "/subscriptions/4bd2aa0f-2bd2-4d67-91a8-5a4533d58600/resourceGroups/sakanwar/providers/Microsoft.Storage/storageAccounts/sakanwar1204usa",
 *         CustomerStorageAccountArmId = "/subscriptions/4bd2aa0f-2bd2-4d67-91a8-5a4533d58600/resourceGroups/sakanwar/providers/Microsoft.Storage/storageAccounts/sakanwar1204usa",
 *         Location = "southeastasia",
 *         ProjectName = "sakanwar1204project",
 *         ProjectStatus = "Active",
 *         ProvisioningState = "Succeeded",
 *         PublicNetworkAccess = "Disabled",
 *         ResourceGroupName = "sakanwar",
 *         Tags =
 *         {
 *             { "Migrate Project", "sakanwar-PE-SEA" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/migrate/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := migrate.NewAssessmentProjectsOperation(ctx, "assessmentProjectsOperation", &migrate.AssessmentProjectsOperationArgs{
 * 			AssessmentSolutionId:        pulumi.String("/subscriptions/4bd2aa0f-2bd2-4d67-91a8-5a4533d58600/resourceGroups/sakanwar/providers/Microsoft.Storage/storageAccounts/sakanwar1204usa"),
 * 			CustomerStorageAccountArmId: pulumi.String("/subscriptions/4bd2aa0f-2bd2-4d67-91a8-5a4533d58600/resourceGroups/sakanwar/providers/Microsoft.Storage/storageAccounts/sakanwar1204usa"),
 * 			Location:                    pulumi.String("southeastasia"),
 * 			ProjectName:                 pulumi.String("sakanwar1204project"),
 * 			ProjectStatus:               pulumi.String("Active"),
 * 			ProvisioningState:           pulumi.String("Succeeded"),
 * 			PublicNetworkAccess:         pulumi.String("Disabled"),
 * 			ResourceGroupName:           pulumi.String("sakanwar"),
 * 			Tags: pulumi.StringMap{
 * 				"Migrate Project": pulumi.String("sakanwar-PE-SEA"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.migrate.AssessmentProjectsOperation;
 * import com.pulumi.azurenative.migrate.AssessmentProjectsOperationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var assessmentProjectsOperation = new AssessmentProjectsOperation("assessmentProjectsOperation", AssessmentProjectsOperationArgs.builder()
 *             .assessmentSolutionId("/subscriptions/4bd2aa0f-2bd2-4d67-91a8-5a4533d58600/resourceGroups/sakanwar/providers/Microsoft.Storage/storageAccounts/sakanwar1204usa")
 *             .customerStorageAccountArmId("/subscriptions/4bd2aa0f-2bd2-4d67-91a8-5a4533d58600/resourceGroups/sakanwar/providers/Microsoft.Storage/storageAccounts/sakanwar1204usa")
 *             .location("southeastasia")
 *             .projectName("sakanwar1204project")
 *             .projectStatus("Active")
 *             .provisioningState("Succeeded")
 *             .publicNetworkAccess("Disabled")
 *             .resourceGroupName("sakanwar")
 *             .tags(Map.of("Migrate Project", "sakanwar-PE-SEA"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:migrate:AssessmentProjectsOperation sakanwar1204project /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/assessmentProjects/{projectName}
 * ```
 */
public class AssessmentProjectsOperation internal constructor(
    override val javaResource: com.pulumi.azurenative.migrate.AssessmentProjectsOperation,
) : KotlinCustomResource(javaResource, AssessmentProjectsOperationMapper) {
    /**
     * Assessment solution ARM id tracked by Microsoft.Migrate/migrateProjects.
     */
    public val assessmentSolutionId: Output<String>?
        get() = javaResource.assessmentSolutionId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Time when this project was created. Date-Time represented in ISO-8601 format.
     */
    public val createdTimestamp: Output<String>
        get() = javaResource.createdTimestamp().applyValue({ args0 -> args0 })

    /**
     * The ARM id of the storage account used for interactions when public access is
     * disabled.
     */
    public val customerStorageAccountArmId: Output<String>?
        get() = javaResource.customerStorageAccountArmId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ARM id of service map workspace created by customer.
     */
    public val customerWorkspaceId: Output<String>?
        get() = javaResource.customerWorkspaceId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Location of service map workspace created by customer.
     */
    public val customerWorkspaceLocation: Output<String>?
        get() = javaResource.customerWorkspaceLocation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The list of private endpoint connections to the project.
     */
    public val privateEndpointConnections: Output<List<PrivateEndpointConnectionResponse>>
        get() = javaResource.privateEndpointConnections().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> privateEndpointConnectionResponseToKotlin(args0) })
            })
        })

    /**
     * Assessment project status.
     */
    public val projectStatus: Output<String>?
        get() = javaResource.projectStatus().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The status of the last operation.
     */
    public val provisioningState: Output<String>?
        get() = javaResource.provisioningState().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * This value can be set to 'enabled' to avoid breaking changes on existing
     * customer resources and templates. If set to 'disabled', traffic over public
     * interface is not allowed, and private endpoint connections would be the
     * exclusive access method.
     */
    public val publicNetworkAccess: Output<String>?
        get() = javaResource.publicNetworkAccess().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Endpoint at which the collector agent can call agent REST API.
     */
    public val serviceEndpoint: Output<String>
        get() = javaResource.serviceEndpoint().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Time when this project was last updated. Date-Time represented in ISO-8601
     * format.
     */
    public val updatedTimestamp: Output<String>
        get() = javaResource.updatedTimestamp().applyValue({ args0 -> args0 })
}

public object AssessmentProjectsOperationMapper : ResourceMapper<AssessmentProjectsOperation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.migrate.AssessmentProjectsOperation::class == javaResource::class

    override fun map(javaResource: Resource): AssessmentProjectsOperation =
        AssessmentProjectsOperation(
            javaResource as
                com.pulumi.azurenative.migrate.AssessmentProjectsOperation,
        )
}

/**
 * @see [AssessmentProjectsOperation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AssessmentProjectsOperation].
 */
public suspend fun assessmentProjectsOperation(
    name: String,
    block: suspend AssessmentProjectsOperationResourceBuilder.() -> Unit,
):
    AssessmentProjectsOperation {
    val builder = AssessmentProjectsOperationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AssessmentProjectsOperation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun assessmentProjectsOperation(name: String): AssessmentProjectsOperation {
    val builder = AssessmentProjectsOperationResourceBuilder()
    builder.name(name)
    return builder.build()
}
