@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin

import com.pulumi.azurenative.migrate.MigrateProjectsControllerMigrateProjectArgs.builder
import com.pulumi.azurenative.migrate.kotlin.inputs.MigrateProjectPropertiesArgs
import com.pulumi.azurenative.migrate.kotlin.inputs.MigrateProjectPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Migrate project.
 * Azure REST API version: 2020-05-01.
 * Other available API versions: 2023-01-01.
 * ## Example Usage
 * ### MigrateProject_Put
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var migrateProjectsControllerMigrateProject = new AzureNative.Migrate.MigrateProjectsControllerMigrateProject("migrateProjectsControllerMigrateProject", new()
 *     {
 *         Location = "eastus",
 *         MigrateProjectName = "projTest1",
 *         Properties = new AzureNative.Migrate.Inputs.MigrateProjectPropertiesArgs
 *         {
 *             PublicNetworkAccess = "Enabled",
 *         },
 *         ResourceGroupName = "pajindTest1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/migrate/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := migrate.NewMigrateProjectsControllerMigrateProject(ctx, "migrateProjectsControllerMigrateProject", &migrate.MigrateProjectsControllerMigrateProjectArgs{
 * 			Location:           pulumi.String("eastus"),
 * 			MigrateProjectName: pulumi.String("projTest1"),
 * 			Properties: &migrate.MigrateProjectPropertiesArgs{
 * 				PublicNetworkAccess: pulumi.String("Enabled"),
 * 			},
 * 			ResourceGroupName: pulumi.String("pajindTest1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.migrate.MigrateProjectsControllerMigrateProject;
 * import com.pulumi.azurenative.migrate.MigrateProjectsControllerMigrateProjectArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var migrateProjectsControllerMigrateProject = new MigrateProjectsControllerMigrateProject("migrateProjectsControllerMigrateProject", MigrateProjectsControllerMigrateProjectArgs.builder()
 *             .location("eastus")
 *             .migrateProjectName("projTest1")
 *             .properties(Map.of("publicNetworkAccess", "Enabled"))
 *             .resourceGroupName("pajindTest1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:migrate:MigrateProjectsControllerMigrateProject proj90 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/migrateProjects/{migrateProjectName}
 * ```
 * @property eTag For optimistic concurrency control.
 * @property location Azure location in which project is created.
 * @property migrateProjectName Migrate project name.
 * @property properties Properties of a migrate project.
 * @property resourceGroupName Name of the Azure Resource Group that project is part of.
 */
public data class MigrateProjectsControllerMigrateProjectArgs(
    public val eTag: Output<String>? = null,
    public val location: Output<String>? = null,
    public val migrateProjectName: Output<String>? = null,
    public val properties: Output<MigrateProjectPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.MigrateProjectsControllerMigrateProjectArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.MigrateProjectsControllerMigrateProjectArgs =
        com.pulumi.azurenative.migrate.MigrateProjectsControllerMigrateProjectArgs.builder()
            .eTag(eTag?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .migrateProjectName(migrateProjectName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MigrateProjectsControllerMigrateProjectArgs].
 */
@PulumiTagMarker
public class MigrateProjectsControllerMigrateProjectArgsBuilder internal constructor() {
    private var eTag: Output<String>? = null

    private var location: Output<String>? = null

    private var migrateProjectName: Output<String>? = null

    private var properties: Output<MigrateProjectPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value For optimistic concurrency control.
     */
    @JvmName("ajkmwwmmnyveufcx")
    public suspend fun eTag(`value`: Output<String>) {
        this.eTag = value
    }

    /**
     * @param value Azure location in which project is created.
     */
    @JvmName("jlqvdxuanusxsyss")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Migrate project name.
     */
    @JvmName("ovjogiwvidbaswsh")
    public suspend fun migrateProjectName(`value`: Output<String>) {
        this.migrateProjectName = value
    }

    /**
     * @param value Properties of a migrate project.
     */
    @JvmName("cpxgftvkotlpuejl")
    public suspend fun properties(`value`: Output<MigrateProjectPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value Name of the Azure Resource Group that project is part of.
     */
    @JvmName("raxuuxasxntpnnch")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value For optimistic concurrency control.
     */
    @JvmName("wurxrwxrbfgpjkhi")
    public suspend fun eTag(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eTag = mapped
    }

    /**
     * @param value Azure location in which project is created.
     */
    @JvmName("cjptfevgwklhgquc")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Migrate project name.
     */
    @JvmName("xsipinpnbwwtgfbq")
    public suspend fun migrateProjectName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.migrateProjectName = mapped
    }

    /**
     * @param value Properties of a migrate project.
     */
    @JvmName("euvdrtkqhpjjbajf")
    public suspend fun properties(`value`: MigrateProjectPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Properties of a migrate project.
     */
    @JvmName("vqnqyukpgiiqajxq")
    public suspend fun properties(argument: suspend MigrateProjectPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = MigrateProjectPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value Name of the Azure Resource Group that project is part of.
     */
    @JvmName("erbtxrqkjaefstps")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): MigrateProjectsControllerMigrateProjectArgs =
        MigrateProjectsControllerMigrateProjectArgs(
            eTag = eTag,
            location = location,
            migrateProjectName = migrateProjectName,
            properties = properties,
            resourceGroupName = resourceGroupName,
        )
}
