@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin

import com.pulumi.azurenative.migrate.ModernizeProjectArgs.builder
import com.pulumi.azurenative.migrate.kotlin.inputs.ModernizeProjectModelPropertiesArgs
import com.pulumi.azurenative.migrate.kotlin.inputs.ModernizeProjectModelPropertiesArgsBuilder
import com.pulumi.azurenative.migrate.kotlin.inputs.ResourceIdentityArgs
import com.pulumi.azurenative.migrate.kotlin.inputs.ResourceIdentityArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * ModernizeProject model.
 * Azure REST API version: 2022-05-01-preview.
 * ## Example Usage
 * ### ModernizeProject_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var modernizeProject = new AzureNative.Migrate.ModernizeProject("modernizeProject", new()
 *     {
 *         Identity = new AzureNative.Migrate.Inputs.ResourceIdentityArgs
 *         {
 *             PrincipalId = "ins",
 *             TenantId = "fjnu",
 *             Type = "None",
 *             UserAssignedIdentities =
 *             {
 *                 { "key6848", new AzureNative.Migrate.Inputs.UserAssignedIdentityArgs
 *                 {
 *                     ClientId = "lvlngepacjdjryqmxuvfdxwtkc",
 *                     PrincipalId = "lumkynazsspljxiiwvz",
 *                 } },
 *             },
 *         },
 *         Location = "nbqyuxrgrlhx",
 *         ModernizeProjectName = "b",
 *         Properties = new AzureNative.Migrate.Inputs.ModernizeProjectModelPropertiesArgs
 *         {
 *             MigrationConfiguration = new AzureNative.Migrate.Inputs.MigrationConfigurationArgs
 *             {
 *                 KeyVaultResourceId = "vekhittkyogvwnqmggknv",
 *                 MigrationSolutionResourceId = "bglfkwtzvqmhwpddwpvtdzaleaioxo",
 *                 StorageAccountResourceId = "dgcoticysafrpynyoxkgrspooiia",
 *             },
 *         },
 *         ResourceGroupName = "rgmigrateEngine",
 *         Tags =
 *         {
 *             { "key8644", "wfyi" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/migrate/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := migrate.NewModernizeProject(ctx, "modernizeProject", &migrate.ModernizeProjectArgs{
 * 			Identity: migrate.ResourceIdentityResponse{
 * 				PrincipalId: pulumi.String("ins"),
 * 				TenantId:    pulumi.String("fjnu"),
 * 				Type:        pulumi.String("None"),
 * 				UserAssignedIdentities: migrate.UserAssignedIdentityMap{
 * 					"key6848": &migrate.UserAssignedIdentityArgs{
 * 						ClientId:    pulumi.String("lvlngepacjdjryqmxuvfdxwtkc"),
 * 						PrincipalId: pulumi.String("lumkynazsspljxiiwvz"),
 * 					},
 * 				},
 * 			},
 * 			Location:             pulumi.String("nbqyuxrgrlhx"),
 * 			ModernizeProjectName: pulumi.String("b"),
 * 			Properties: migrate.ModernizeProjectModelPropertiesResponse{
 * 				MigrationConfiguration: &migrate.MigrationConfigurationArgs{
 * 					KeyVaultResourceId:          pulumi.String("vekhittkyogvwnqmggknv"),
 * 					MigrationSolutionResourceId: pulumi.String("bglfkwtzvqmhwpddwpvtdzaleaioxo"),
 * 					StorageAccountResourceId:    pulumi.String("dgcoticysafrpynyoxkgrspooiia"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("rgmigrateEngine"),
 * 			Tags: pulumi.StringMap{
 * 				"key8644": pulumi.String("wfyi"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.migrate.ModernizeProject;
 * import com.pulumi.azurenative.migrate.ModernizeProjectArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var modernizeProject = new ModernizeProject("modernizeProject", ModernizeProjectArgs.builder()
 *             .identity(Map.ofEntries(
 *                 Map.entry("principalId", "ins"),
 *                 Map.entry("tenantId", "fjnu"),
 *                 Map.entry("type", "None"),
 *                 Map.entry("userAssignedIdentities", Map.of("key6848", Map.ofEntries(
 *                     Map.entry("clientId", "lvlngepacjdjryqmxuvfdxwtkc"),
 *                     Map.entry("principalId", "lumkynazsspljxiiwvz")
 *                 )))
 *             ))
 *             .location("nbqyuxrgrlhx")
 *             .modernizeProjectName("b")
 *             .properties(Map.of("migrationConfiguration", Map.ofEntries(
 *                 Map.entry("keyVaultResourceId", "vekhittkyogvwnqmggknv"),
 *                 Map.entry("migrationSolutionResourceId", "bglfkwtzvqmhwpddwpvtdzaleaioxo"),
 *                 Map.entry("storageAccountResourceId", "dgcoticysafrpynyoxkgrspooiia")
 *             )))
 *             .resourceGroupName("rgmigrateEngine")
 *             .tags(Map.of("key8644", "wfyi"))
 *             .build());
 *     }
 * }
 * ```
 * ### ModernizeProject_Create_MinimumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var modernizeProject = new AzureNative.Migrate.ModernizeProject("modernizeProject", new()
 *     {
 *         ModernizeProjectName = "j",
 *         ResourceGroupName = "rgmigrateEngine",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/migrate/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := migrate.NewModernizeProject(ctx, "modernizeProject", &migrate.ModernizeProjectArgs{
 * 			ModernizeProjectName: pulumi.String("j"),
 * 			ResourceGroupName:    pulumi.String("rgmigrateEngine"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.migrate.ModernizeProject;
 * import com.pulumi.azurenative.migrate.ModernizeProjectArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var modernizeProject = new ModernizeProject("modernizeProject", ModernizeProjectArgs.builder()
 *             .modernizeProjectName("j")
 *             .resourceGroupName("rgmigrateEngine")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:migrate:ModernizeProject qjtgfttacnihw /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/modernizeProjects/{modernizeProjectName}
 * ```
 * @property identity
 * @property location Gets or sets the location of the modernizeProject.
 * @property modernizeProjectName ModernizeProject Name.
 * @property properties ModernizeProject properties.
 * @property resourceGroupName Name of the Azure Resource Group that project is part of.
 * @property subscriptionId Azure Subscription Id in which project was created.
 * @property tags Gets or sets the resource tags.
 */
public data class ModernizeProjectArgs(
    public val identity: Output<ResourceIdentityArgs>? = null,
    public val location: Output<String>? = null,
    public val modernizeProjectName: Output<String>? = null,
    public val properties: Output<ModernizeProjectModelPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val subscriptionId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.ModernizeProjectArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.ModernizeProjectArgs =
        com.pulumi.azurenative.migrate.ModernizeProjectArgs.builder()
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .modernizeProjectName(modernizeProjectName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .subscriptionId(subscriptionId?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ModernizeProjectArgs].
 */
@PulumiTagMarker
public class ModernizeProjectArgsBuilder internal constructor() {
    private var identity: Output<ResourceIdentityArgs>? = null

    private var location: Output<String>? = null

    private var modernizeProjectName: Output<String>? = null

    private var properties: Output<ModernizeProjectModelPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var subscriptionId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value
     */
    @JvmName("gnxtceekuanoniio")
    public suspend fun identity(`value`: Output<ResourceIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value Gets or sets the location of the modernizeProject.
     */
    @JvmName("qfadhpsfrccstnmy")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value ModernizeProject Name.
     */
    @JvmName("yrlgftlguncvudlh")
    public suspend fun modernizeProjectName(`value`: Output<String>) {
        this.modernizeProjectName = value
    }

    /**
     * @param value ModernizeProject properties.
     */
    @JvmName("aachcbfvhcupvfxq")
    public suspend fun properties(`value`: Output<ModernizeProjectModelPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value Name of the Azure Resource Group that project is part of.
     */
    @JvmName("wjlhwbvmdouqqdjh")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Azure Subscription Id in which project was created.
     */
    @JvmName("ykbhqkcteoyjyknb")
    public suspend fun subscriptionId(`value`: Output<String>) {
        this.subscriptionId = value
    }

    /**
     * @param value Gets or sets the resource tags.
     */
    @JvmName("aucicqdfxliljfij")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value
     */
    @JvmName("axcftlpmerfvjujd")
    public suspend fun identity(`value`: ResourceIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument
     */
    @JvmName("ftnbyuummlnxqsut")
    public suspend fun identity(argument: suspend ResourceIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value Gets or sets the location of the modernizeProject.
     */
    @JvmName("hqmjifywenoutdgs")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value ModernizeProject Name.
     */
    @JvmName("uajhjnkhbslhgmfw")
    public suspend fun modernizeProjectName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.modernizeProjectName = mapped
    }

    /**
     * @param value ModernizeProject properties.
     */
    @JvmName("bejvaqkdhevqkvok")
    public suspend fun properties(`value`: ModernizeProjectModelPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument ModernizeProject properties.
     */
    @JvmName("doxfqvsvjheqegoa")
    public suspend
    fun properties(argument: suspend ModernizeProjectModelPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = ModernizeProjectModelPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value Name of the Azure Resource Group that project is part of.
     */
    @JvmName("evgvukdkmrxlabek")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Azure Subscription Id in which project was created.
     */
    @JvmName("njgdtyfraiwfrahd")
    public suspend fun subscriptionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subscriptionId = mapped
    }

    /**
     * @param value Gets or sets the resource tags.
     */
    @JvmName("fsighmpediwgrovc")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Gets or sets the resource tags.
     */
    @JvmName("toopvobjuuyncyij")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ModernizeProjectArgs = ModernizeProjectArgs(
        identity = identity,
        location = location,
        modernizeProjectName = modernizeProjectName,
        properties = properties,
        resourceGroupName = resourceGroupName,
        subscriptionId = subscriptionId,
        tags = tags,
    )
}
