@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin

import com.pulumi.azurenative.migrate.MoveResourceArgs.builder
import com.pulumi.azurenative.migrate.kotlin.inputs.MoveResourcePropertiesArgs
import com.pulumi.azurenative.migrate.kotlin.inputs.MoveResourcePropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Defines the move resource.
 * Azure REST API version: 2022-08-01. Prior API version in Azure Native 1.x: 2021-01-01.
 * Other available API versions: 2023-08-01.
 * ## Example Usage
 * ### MoveResources_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var moveResource = new AzureNative.Migrate.MoveResource("moveResource", new()
 *     {
 *         MoveCollectionName = "movecollection1",
 *         MoveResourceName = "moveresourcename1",
 *         Properties = new AzureNative.Migrate.Inputs.MoveResourcePropertiesArgs
 *         {
 *             DependsOnOverrides = new[]
 *             {
 *                 new AzureNative.Migrate.Inputs.MoveResourceDependencyOverrideArgs
 *                 {
 *                     Id = "/subscriptions/c4488a3f-a7f7-4ad4-aa72-0e1f4d9c0756/resourceGroups/eastusRG/providers/Microsoft.Network/networkInterfaces/eastusvm140",
 *                     TargetId = "/subscriptions/c4488a3f-a7f7-4ad4-aa72-0e1f4d9c0756/resourceGroups/westusRG/providers/Microsoft.Network/networkInterfaces/eastusvm140",
 *                 },
 *             },
 *             ResourceSettings = new AzureNative.Migrate.Inputs.VirtualMachineResourceSettingsArgs
 *             {
 *                 ResourceType = "Microsoft.Compute/virtualMachines",
 *                 TargetAvailabilitySetId = "/subscriptions/subid/resourceGroups/eastusRG/providers/Microsoft.Compute/availabilitySets/avset1",
 *                 TargetAvailabilityZone = "2",
 *                 TargetResourceName = "westusvm1",
 *                 UserManagedIdentities = new[]
 *                 {
 *                     "/subscriptions/subid/resourceGroups/eastusRG/providers/Microsoft.ManagedIdentity/userAssignedIdentities/umi1",
 *                 },
 *             },
 *             SourceId = "/subscriptions/subid/resourceGroups/eastusRG/providers/Microsoft.Compute/virtualMachines/eastusvm1",
 *         },
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/migrate/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := migrate.NewMoveResource(ctx, "moveResource", &migrate.MoveResourceArgs{
 * 			MoveCollectionName: pulumi.String("movecollection1"),
 * 			MoveResourceName:   pulumi.String("moveresourcename1"),
 * 			Properties: migrate.MoveResourcePropertiesResponse{
 * 				DependsOnOverrides: migrate.MoveResourceDependencyOverrideArray{
 * 					&migrate.MoveResourceDependencyOverrideArgs{
 * 						Id:       pulumi.String("/subscriptions/c4488a3f-a7f7-4ad4-aa72-0e1f4d9c0756/resourceGroups/eastusRG/providers/Microsoft.Network/networkInterfaces/eastusvm140"),
 * 						TargetId: pulumi.String("/subscriptions/c4488a3f-a7f7-4ad4-aa72-0e1f4d9c0756/resourceGroups/westusRG/providers/Microsoft.Network/networkInterfaces/eastusvm140"),
 * 					},
 * 				},
 * 				ResourceSettings: migrate.VirtualMachineResourceSettings{
 * 					ResourceType:            "Microsoft.Compute/virtualMachines",
 * 					TargetAvailabilitySetId: "/subscriptions/subid/resourceGroups/eastusRG/providers/Microsoft.Compute/availabilitySets/avset1",
 * 					TargetAvailabilityZone:  "2",
 * 					TargetResourceName:      "westusvm1",
 * 					UserManagedIdentities: []string{
 * 						"/subscriptions/subid/resourceGroups/eastusRG/providers/Microsoft.ManagedIdentity/userAssignedIdentities/umi1",
 * 					},
 * 				},
 * 				SourceId: pulumi.String("/subscriptions/subid/resourceGroups/eastusRG/providers/Microsoft.Compute/virtualMachines/eastusvm1"),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.migrate.MoveResource;
 * import com.pulumi.azurenative.migrate.MoveResourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var moveResource = new MoveResource("moveResource", MoveResourceArgs.builder()
 *             .moveCollectionName("movecollection1")
 *             .moveResourceName("moveresourcename1")
 *             .properties(Map.ofEntries(
 *                 Map.entry("dependsOnOverrides", Map.ofEntries(
 *                     Map.entry("id", "/subscriptions/c4488a3f-a7f7-4ad4-aa72-0e1f4d9c0756/resourceGroups/eastusRG/providers/Microsoft.Network/networkInterfaces/eastusvm140"),
 *                     Map.entry("targetId", "/subscriptions/c4488a3f-a7f7-4ad4-aa72-0e1f4d9c0756/resourceGroups/westusRG/providers/Microsoft.Network/networkInterfaces/eastusvm140")
 *                 )),
 *                 Map.entry("resourceSettings", Map.ofEntries(
 *                     Map.entry("resourceType", "Microsoft.Compute/virtualMachines"),
 *                     Map.entry("targetAvailabilitySetId", "/subscriptions/subid/resourceGroups/eastusRG/providers/Microsoft.Compute/availabilitySets/avset1"),
 *                     Map.entry("targetAvailabilityZone", "2"),
 *                     Map.entry("targetResourceName", "westusvm1"),
 *                     Map.entry("userManagedIdentities", "/subscriptions/subid/resourceGroups/eastusRG/providers/Microsoft.ManagedIdentity/userAssignedIdentities/umi1")
 *                 )),
 *                 Map.entry("sourceId", "/subscriptions/subid/resourceGroups/eastusRG/providers/Microsoft.Compute/virtualMachines/eastusvm1")
 *             ))
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:migrate:MoveResource moveresourcename1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/moveCollections/{moveCollectionName}/moveResources/{moveResourceName}
 * ```
 * @property moveCollectionName The Move Collection Name.
 * @property moveResourceName The Move Resource Name.
 * @property properties Defines the move resource properties.
 * @property resourceGroupName The Resource Group Name.
 */
public data class MoveResourceArgs(
    public val moveCollectionName: Output<String>? = null,
    public val moveResourceName: Output<String>? = null,
    public val properties: Output<MoveResourcePropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.MoveResourceArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.MoveResourceArgs =
        com.pulumi.azurenative.migrate.MoveResourceArgs.builder()
            .moveCollectionName(moveCollectionName?.applyValue({ args0 -> args0 }))
            .moveResourceName(moveResourceName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MoveResourceArgs].
 */
@PulumiTagMarker
public class MoveResourceArgsBuilder internal constructor() {
    private var moveCollectionName: Output<String>? = null

    private var moveResourceName: Output<String>? = null

    private var properties: Output<MoveResourcePropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value The Move Collection Name.
     */
    @JvmName("pqdjufjxafsydxum")
    public suspend fun moveCollectionName(`value`: Output<String>) {
        this.moveCollectionName = value
    }

    /**
     * @param value The Move Resource Name.
     */
    @JvmName("uqhdvtyrndxwlexi")
    public suspend fun moveResourceName(`value`: Output<String>) {
        this.moveResourceName = value
    }

    /**
     * @param value Defines the move resource properties.
     */
    @JvmName("osjpdhiqsqnddmtq")
    public suspend fun properties(`value`: Output<MoveResourcePropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The Resource Group Name.
     */
    @JvmName("tfkdrfaeqkodtffd")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The Move Collection Name.
     */
    @JvmName("dggycntpyfbapcsr")
    public suspend fun moveCollectionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.moveCollectionName = mapped
    }

    /**
     * @param value The Move Resource Name.
     */
    @JvmName("ckesgfmtegobltjl")
    public suspend fun moveResourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.moveResourceName = mapped
    }

    /**
     * @param value Defines the move resource properties.
     */
    @JvmName("iaxwgswkjgbdhgnu")
    public suspend fun properties(`value`: MoveResourcePropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Defines the move resource properties.
     */
    @JvmName("bhoarmwgxnbwauig")
    public suspend fun properties(argument: suspend MoveResourcePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = MoveResourcePropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The Resource Group Name.
     */
    @JvmName("ulhrsjaowlxxqdse")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): MoveResourceArgs = MoveResourceArgs(
        moveCollectionName = moveCollectionName,
        moveResourceName = moveResourceName,
        properties = properties,
        resourceGroupName = resourceGroupName,
    )
}
