@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin

import com.pulumi.azurenative.migrate.SqlCollectorOperationArgs.builder
import com.pulumi.azurenative.migrate.kotlin.enums.ProvisioningState
import com.pulumi.azurenative.migrate.kotlin.inputs.CollectorAgentPropertiesBaseArgs
import com.pulumi.azurenative.migrate.kotlin.inputs.CollectorAgentPropertiesBaseArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The SQL collector REST object.
 * Azure REST API version: 2023-03-15.
 * ## Example Usage
 * ### SqlCollectorOperations_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sqlCollectorOperation = new AzureNative.Migrate.SqlCollectorOperation("sqlCollectorOperation", new()
 *     {
 *         AgentProperties = new AzureNative.Migrate.Inputs.CollectorAgentPropertiesBaseArgs
 *         {
 *             Id = "630da710-4d44-41f7-a189-72fe3db5502b-agent",
 *             SpnDetails = new AzureNative.Migrate.Inputs.CollectorAgentSpnPropertiesBaseArgs
 *             {
 *                 ApplicationId = "db9c4c3d-477c-4d5a-817b-318276713565",
 *                 Audience = "db9c4c3d-477c-4d5a-817b-318276713565",
 *                 Authority = "https://login.windows.net/72f988bf-86f1-41af-91ab-2d7cd011db47",
 *                 ObjectId = "e50236ad-ad07-47d4-af71-ed7b52d200d5",
 *                 TenantId = "72f988bf-86f1-41af-91ab-2d7cd011db47",
 *             },
 *         },
 *         CollectorName = "fci-test0c1esqlsitecollector",
 *         DiscoverySiteId = "/subscriptions/4bd2aa0f-2bd2-4d67-91a8-5a4533d58600/resourceGroups/bansalankit-rg/providers/Microsoft.OffAzure/MasterSites/fci-ankit-test6065mastersite/SqlSites/fci-ankit-test6065sqlsites",
 *         ProjectName = "fci-test6904project",
 *         ResourceGroupName = "rgmigrate",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/migrate/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := migrate.NewSqlCollectorOperation(ctx, "sqlCollectorOperation", &migrate.SqlCollectorOperationArgs{
 * 			AgentProperties: migrate.CollectorAgentPropertiesBaseResponse{
 * 				Id: pulumi.String("630da710-4d44-41f7-a189-72fe3db5502b-agent"),
 * 				SpnDetails: &migrate.CollectorAgentSpnPropertiesBaseArgs{
 * 					ApplicationId: pulumi.String("db9c4c3d-477c-4d5a-817b-318276713565"),
 * 					Audience:      pulumi.String("db9c4c3d-477c-4d5a-817b-318276713565"),
 * 					Authority:     pulumi.String("https://login.windows.net/72f988bf-86f1-41af-91ab-2d7cd011db47"),
 * 					ObjectId:      pulumi.String("e50236ad-ad07-47d4-af71-ed7b52d200d5"),
 * 					TenantId:      pulumi.String("72f988bf-86f1-41af-91ab-2d7cd011db47"),
 * 				},
 * 			},
 * 			CollectorName:     pulumi.String("fci-test0c1esqlsitecollector"),
 * 			DiscoverySiteId:   pulumi.String("/subscriptions/4bd2aa0f-2bd2-4d67-91a8-5a4533d58600/resourceGroups/bansalankit-rg/providers/Microsoft.OffAzure/MasterSites/fci-ankit-test6065mastersite/SqlSites/fci-ankit-test6065sqlsites"),
 * 			ProjectName:       pulumi.String("fci-test6904project"),
 * 			ResourceGroupName: pulumi.String("rgmigrate"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.migrate.SqlCollectorOperation;
 * import com.pulumi.azurenative.migrate.SqlCollectorOperationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sqlCollectorOperation = new SqlCollectorOperation("sqlCollectorOperation", SqlCollectorOperationArgs.builder()
 *             .agentProperties(Map.ofEntries(
 *                 Map.entry("id", "630da710-4d44-41f7-a189-72fe3db5502b-agent"),
 *                 Map.entry("spnDetails", Map.ofEntries(
 *                     Map.entry("applicationId", "db9c4c3d-477c-4d5a-817b-318276713565"),
 *                     Map.entry("audience", "db9c4c3d-477c-4d5a-817b-318276713565"),
 *                     Map.entry("authority", "https://login.windows.net/72f988bf-86f1-41af-91ab-2d7cd011db47"),
 *                     Map.entry("objectId", "e50236ad-ad07-47d4-af71-ed7b52d200d5"),
 *                     Map.entry("tenantId", "72f988bf-86f1-41af-91ab-2d7cd011db47")
 *                 ))
 *             ))
 *             .collectorName("fci-test0c1esqlsitecollector")
 *             .discoverySiteId("/subscriptions/4bd2aa0f-2bd2-4d67-91a8-5a4533d58600/resourceGroups/bansalankit-rg/providers/Microsoft.OffAzure/MasterSites/fci-ankit-test6065mastersite/SqlSites/fci-ankit-test6065sqlsites")
 *             .projectName("fci-test6904project")
 *             .resourceGroupName("rgmigrate")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:migrate:SqlCollectorOperation fci-test0c1esqlsitecollector /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/assessmentProjects/{projectName}/sqlcollectors/{collectorName}
 * ```
 * @property agentProperties Gets or sets the collector agent properties.
 * @property collectorName Sql collector ARM name.
 * @property discoverySiteId Gets the discovery site id.
 * @property projectName Assessment Project Name
 * @property provisioningState The status of the last operation.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class SqlCollectorOperationArgs(
    public val agentProperties: Output<CollectorAgentPropertiesBaseArgs>? = null,
    public val collectorName: Output<String>? = null,
    public val discoverySiteId: Output<String>? = null,
    public val projectName: Output<String>? = null,
    public val provisioningState: Output<Either<String, ProvisioningState>>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.SqlCollectorOperationArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.SqlCollectorOperationArgs =
        com.pulumi.azurenative.migrate.SqlCollectorOperationArgs.builder()
            .agentProperties(agentProperties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .collectorName(collectorName?.applyValue({ args0 -> args0 }))
            .discoverySiteId(discoverySiteId?.applyValue({ args0 -> args0 }))
            .projectName(projectName?.applyValue({ args0 -> args0 }))
            .provisioningState(
                provisioningState?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SqlCollectorOperationArgs].
 */
@PulumiTagMarker
public class SqlCollectorOperationArgsBuilder internal constructor() {
    private var agentProperties: Output<CollectorAgentPropertiesBaseArgs>? = null

    private var collectorName: Output<String>? = null

    private var discoverySiteId: Output<String>? = null

    private var projectName: Output<String>? = null

    private var provisioningState: Output<Either<String, ProvisioningState>>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value Gets or sets the collector agent properties.
     */
    @JvmName("wahmsdwnhcqmtwvr")
    public suspend fun agentProperties(`value`: Output<CollectorAgentPropertiesBaseArgs>) {
        this.agentProperties = value
    }

    /**
     * @param value Sql collector ARM name.
     */
    @JvmName("baxapcpmucwgpdrn")
    public suspend fun collectorName(`value`: Output<String>) {
        this.collectorName = value
    }

    /**
     * @param value Gets the discovery site id.
     */
    @JvmName("lereqplsrnuhvnon")
    public suspend fun discoverySiteId(`value`: Output<String>) {
        this.discoverySiteId = value
    }

    /**
     * @param value Assessment Project Name
     */
    @JvmName("bwmlmbkoxuiugyta")
    public suspend fun projectName(`value`: Output<String>) {
        this.projectName = value
    }

    /**
     * @param value The status of the last operation.
     */
    @JvmName("mdwiiyatrscqcdhb")
    public suspend fun provisioningState(`value`: Output<Either<String, ProvisioningState>>) {
        this.provisioningState = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("hgvqqjccqexrmbaw")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Gets or sets the collector agent properties.
     */
    @JvmName("gekbilxjltjbegmw")
    public suspend fun agentProperties(`value`: CollectorAgentPropertiesBaseArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.agentProperties = mapped
    }

    /**
     * @param argument Gets or sets the collector agent properties.
     */
    @JvmName("kqnoytcviaxdvpdy")
    public suspend
    fun agentProperties(argument: suspend CollectorAgentPropertiesBaseArgsBuilder.() -> Unit) {
        val toBeMapped = CollectorAgentPropertiesBaseArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.agentProperties = mapped
    }

    /**
     * @param value Sql collector ARM name.
     */
    @JvmName("nolqtqpuohwyrkdx")
    public suspend fun collectorName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.collectorName = mapped
    }

    /**
     * @param value Gets the discovery site id.
     */
    @JvmName("lvlmrmgmjyvnfifp")
    public suspend fun discoverySiteId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.discoverySiteId = mapped
    }

    /**
     * @param value Assessment Project Name
     */
    @JvmName("ijdutrfymsrmxnug")
    public suspend fun projectName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.projectName = mapped
    }

    /**
     * @param value The status of the last operation.
     */
    @JvmName("irdlrmnodxncrtyn")
    public suspend fun provisioningState(`value`: Either<String, ProvisioningState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value The status of the last operation.
     */
    @JvmName("mafgdakeigemnudu")
    public fun provisioningState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ProvisioningState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value The status of the last operation.
     */
    @JvmName("tlcogqsgptxvnsfd")
    public fun provisioningState(`value`: ProvisioningState) {
        val toBeMapped = Either.ofRight<String, ProvisioningState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ghducdnojjaylorp")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): SqlCollectorOperationArgs = SqlCollectorOperationArgs(
        agentProperties = agentProperties,
        collectorName = collectorName,
        discoverySiteId = discoverySiteId,
        projectName = projectName,
        provisioningState = provisioningState,
        resourceGroupName = resourceGroupName,
    )
}
