@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin

import com.pulumi.azurenative.migrate.VMwareCollectorArgs.builder
import com.pulumi.azurenative.migrate.kotlin.inputs.CollectorPropertiesArgs
import com.pulumi.azurenative.migrate.kotlin.inputs.CollectorPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * Azure REST API version: 2019-10-01. Prior API version in Azure Native 1.x: 2019-10-01.
 * ## Example Usage
 * ### VMwareCollectors_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var vMwareCollector = new AzureNative.Migrate.VMwareCollector("vMwareCollector", new()
 *     {
 *         ETag = "\"01003d32-0000-0d00-0000-5d74d2e50000\"",
 *         ProjectName = "abgoyalWEselfhostb72bproject",
 *         Properties = new AzureNative.Migrate.Inputs.CollectorPropertiesArgs
 *         {
 *             AgentProperties = new AzureNative.Migrate.Inputs.CollectorAgentPropertiesArgs
 *             {
 *                 SpnDetails = new AzureNative.Migrate.Inputs.CollectorBodyAgentSpnPropertiesArgs
 *                 {
 *                     ApplicationId = "fc717575-8173-4b21-92a5-658b655e613e",
 *                     Audience = "https://72f988bf-86f1-41af-91ab-2d7cd011db47/PortalvCenterbc2fagentauthaadapp",
 *                     Authority = "https://login.windows.net/72f988bf-86f1-41af-91ab-2d7cd011db47",
 *                     ObjectId = "29d94f38-db94-4980-aec0-0cfd55ab1cd0",
 *                     TenantId = "72f988bf-86f1-41af-91ab-2d7cd011db47",
 *                 },
 *             },
 *             DiscoverySiteId = "/subscriptions/6393a73f-8d55-47ef-b6dd-179b3e0c7910/resourceGroups/abgoyal-westEurope/providers/Microsoft.OffAzure/VMwareSites/PortalvCenterbc2fsite",
 *         },
 *         ResourceGroupName = "abgoyal-westEurope",
 *         VmWareCollectorName = "PortalvCenterbc2fcollector",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/migrate/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := migrate.NewVMwareCollector(ctx, "vMwareCollector", &migrate.VMwareCollectorArgs{
 * ETag: pulumi.String("\"01003d32-0000-0d00-0000-5d74d2e50000\""),
 * ProjectName: pulumi.String("abgoyalWEselfhostb72bproject"),
 * Properties: migrate.CollectorPropertiesResponse{
 * AgentProperties: interface{}{
 * SpnDetails: &migrate.CollectorBodyAgentSpnPropertiesArgs{
 * ApplicationId: pulumi.String("fc717575-8173-4b21-92a5-658b655e613e"),
 * Audience: pulumi.String("https://72f988bf-86f1-41af-91ab-2d7cd011db47/PortalvCenterbc2fagentauthaadapp"),
 * Authority: pulumi.String("https://login.windows.net/72f988bf-86f1-41af-91ab-2d7cd011db47"),
 * ObjectId: pulumi.String("29d94f38-db94-4980-aec0-0cfd55ab1cd0"),
 * TenantId: pulumi.String("72f988bf-86f1-41af-91ab-2d7cd011db47"),
 * },
 * },
 * DiscoverySiteId: pulumi.String("/subscriptions/6393a73f-8d55-47ef-b6dd-179b3e0c7910/resourceGroups/abgoyal-westEurope/providers/Microsoft.OffAzure/VMwareSites/PortalvCenterbc2fsite"),
 * },
 * ResourceGroupName: pulumi.String("abgoyal-westEurope"),
 * VmWareCollectorName: pulumi.String("PortalvCenterbc2fcollector"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.migrate.VMwareCollector;
 * import com.pulumi.azurenative.migrate.VMwareCollectorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var vMwareCollector = new VMwareCollector("vMwareCollector", VMwareCollectorArgs.builder()
 *             .eTag("\"01003d32-0000-0d00-0000-5d74d2e50000\"")
 *             .projectName("abgoyalWEselfhostb72bproject")
 *             .properties(Map.ofEntries(
 *                 Map.entry("agentProperties", Map.of("spnDetails", Map.ofEntries(
 *                     Map.entry("applicationId", "fc717575-8173-4b21-92a5-658b655e613e"),
 *                     Map.entry("audience", "https://72f988bf-86f1-41af-91ab-2d7cd011db47/PortalvCenterbc2fagentauthaadapp"),
 *                     Map.entry("authority", "https://login.windows.net/72f988bf-86f1-41af-91ab-2d7cd011db47"),
 *                     Map.entry("objectId", "29d94f38-db94-4980-aec0-0cfd55ab1cd0"),
 *                     Map.entry("tenantId", "72f988bf-86f1-41af-91ab-2d7cd011db47")
 *                 ))),
 *                 Map.entry("discoverySiteId", "/subscriptions/6393a73f-8d55-47ef-b6dd-179b3e0c7910/resourceGroups/abgoyal-westEurope/providers/Microsoft.OffAzure/VMwareSites/PortalvCenterbc2fsite")
 *             ))
 *             .resourceGroupName("abgoyal-westEurope")
 *             .vmWareCollectorName("PortalvCenterbc2fcollector")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:migrate:VMwareCollector PortalvCenterbc2fcollector /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/assessmentProjects/{projectName}/vmwarecollectors/{vmWareCollectorName}
 * ```
 * @property eTag
 * @property projectName Name of the Azure Migrate project.
 * @property properties
 * @property resourceGroupName Name of the Azure Resource Group that project is part of.
 * @property vmWareCollectorName Unique name of a VMware collector within a project.
 */
public data class VMwareCollectorArgs(
    public val eTag: Output<String>? = null,
    public val projectName: Output<String>? = null,
    public val properties: Output<CollectorPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val vmWareCollectorName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.VMwareCollectorArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.VMwareCollectorArgs =
        com.pulumi.azurenative.migrate.VMwareCollectorArgs.builder()
            .eTag(eTag?.applyValue({ args0 -> args0 }))
            .projectName(projectName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .vmWareCollectorName(vmWareCollectorName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VMwareCollectorArgs].
 */
@PulumiTagMarker
public class VMwareCollectorArgsBuilder internal constructor() {
    private var eTag: Output<String>? = null

    private var projectName: Output<String>? = null

    private var properties: Output<CollectorPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var vmWareCollectorName: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("hhwsijtcnqnrpslf")
    public suspend fun eTag(`value`: Output<String>) {
        this.eTag = value
    }

    /**
     * @param value Name of the Azure Migrate project.
     */
    @JvmName("jpdftbooivujkxjx")
    public suspend fun projectName(`value`: Output<String>) {
        this.projectName = value
    }

    /**
     * @param value
     */
    @JvmName("siywsodllrobsvuk")
    public suspend fun properties(`value`: Output<CollectorPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value Name of the Azure Resource Group that project is part of.
     */
    @JvmName("jfapjnitnvdvwbfs")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Unique name of a VMware collector within a project.
     */
    @JvmName("akccoshfjnrneglw")
    public suspend fun vmWareCollectorName(`value`: Output<String>) {
        this.vmWareCollectorName = value
    }

    /**
     * @param value
     */
    @JvmName("kmnmbyleocnphedy")
    public suspend fun eTag(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eTag = mapped
    }

    /**
     * @param value Name of the Azure Migrate project.
     */
    @JvmName("vxtlkrovmcfudccx")
    public suspend fun projectName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.projectName = mapped
    }

    /**
     * @param value
     */
    @JvmName("qxyhdieleejokees")
    public suspend fun properties(`value`: CollectorPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument
     */
    @JvmName("absmghdlqcnwptvh")
    public suspend fun properties(argument: suspend CollectorPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = CollectorPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value Name of the Azure Resource Group that project is part of.
     */
    @JvmName("nuqgojhudoarfwgb")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Unique name of a VMware collector within a project.
     */
    @JvmName("rootyknvtusswrut")
    public suspend fun vmWareCollectorName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vmWareCollectorName = mapped
    }

    internal fun build(): VMwareCollectorArgs = VMwareCollectorArgs(
        eTag = eTag,
        projectName = projectName,
        properties = properties,
        resourceGroupName = resourceGroupName,
        vmWareCollectorName = vmWareCollectorName,
    )
}
