@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin

import com.pulumi.azurenative.migrate.kotlin.outputs.CollectorAgentPropertiesBaseResponse
import com.pulumi.azurenative.migrate.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.migrate.kotlin.outputs.CollectorAgentPropertiesBaseResponse.Companion.toKotlin as collectorAgentPropertiesBaseResponseToKotlin
import com.pulumi.azurenative.migrate.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [VmwareCollectorsOperation].
 */
@PulumiTagMarker
public class VmwareCollectorsOperationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VmwareCollectorsOperationArgs = VmwareCollectorsOperationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VmwareCollectorsOperationArgsBuilder.() -> Unit) {
        val builder = VmwareCollectorsOperationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): VmwareCollectorsOperation {
        val builtJavaResource =
            com.pulumi.azurenative.migrate.VmwareCollectorsOperation(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return VmwareCollectorsOperation(builtJavaResource)
    }
}

/**
 * VMware collector resource.
 * Azure REST API version: 2023-03-15.
 * ## Example Usage
 * ### VmwareCollectorsOperations_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var vmwareCollectorsOperation = new AzureNative.Migrate.VmwareCollectorsOperation("vmwareCollectorsOperation", new()
 *     {
 *         AgentProperties = new AzureNative.Migrate.Inputs.CollectorAgentPropertiesBaseArgs
 *         {
 *             Id = "fe243486-3318-41fa-aaba-c48b5df75308",
 *             LastHeartbeatUtc = "2022-03-29T12:10:08.9167289Z",
 *             SpnDetails = new AzureNative.Migrate.Inputs.CollectorAgentSpnPropertiesBaseArgs
 *             {
 *                 ApplicationId = "82b3e452-c0e8-4662-8347-58282925ae84",
 *                 Audience = "82b3e452-c0e8-4662-8347-58282925ae84",
 *                 Authority = "https://login.windows.net/72f988bf-86f1-41af-91ab-2d7cd011db47",
 *                 ObjectId = "3fc89111-1405-4938-9214-37aa4739401d",
 *                 TenantId = "72f988bf-86f1-41af-91ab-2d7cd011db47",
 *             },
 *             Version = "1.0.8.383",
 *         },
 *         DiscoverySiteId = "/subscriptions/4bd2aa0f-2bd2-4d67-91a8-5a4533d58600/resourceGroups/ayagrawRG/providers/Microsoft.OffAzure/VMwareSites/Vmware2744site",
 *         ProjectName = "app18700project",
 *         ProvisioningState = "Succeeded",
 *         ResourceGroupName = "ayagrawRG",
 *         VmWareCollectorName = "Vmware2258collector",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/migrate/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := migrate.NewVmwareCollectorsOperation(ctx, "vmwareCollectorsOperation", &migrate.VmwareCollectorsOperationArgs{
 * 			AgentProperties: migrate.CollectorAgentPropertiesBaseResponse{
 * 				Id:               pulumi.String("fe243486-3318-41fa-aaba-c48b5df75308"),
 * 				LastHeartbeatUtc: pulumi.String("2022-03-29T12:10:08.9167289Z"),
 * 				SpnDetails: &migrate.CollectorAgentSpnPropertiesBaseArgs{
 * 					ApplicationId: pulumi.String("82b3e452-c0e8-4662-8347-58282925ae84"),
 * 					Audience:      pulumi.String("82b3e452-c0e8-4662-8347-58282925ae84"),
 * 					Authority:     pulumi.String("https://login.windows.net/72f988bf-86f1-41af-91ab-2d7cd011db47"),
 * 					ObjectId:      pulumi.String("3fc89111-1405-4938-9214-37aa4739401d"),
 * 					TenantId:      pulumi.String("72f988bf-86f1-41af-91ab-2d7cd011db47"),
 * 				},
 * 				Version: pulumi.String("1.0.8.383"),
 * 			},
 * 			DiscoverySiteId:     pulumi.String("/subscriptions/4bd2aa0f-2bd2-4d67-91a8-5a4533d58600/resourceGroups/ayagrawRG/providers/Microsoft.OffAzure/VMwareSites/Vmware2744site"),
 * 			ProjectName:         pulumi.String("app18700project"),
 * 			ProvisioningState:   pulumi.String("Succeeded"),
 * 			ResourceGroupName:   pulumi.String("ayagrawRG"),
 * 			VmWareCollectorName: pulumi.String("Vmware2258collector"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.migrate.VmwareCollectorsOperation;
 * import com.pulumi.azurenative.migrate.VmwareCollectorsOperationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var vmwareCollectorsOperation = new VmwareCollectorsOperation("vmwareCollectorsOperation", VmwareCollectorsOperationArgs.builder()
 *             .agentProperties(Map.ofEntries(
 *                 Map.entry("id", "fe243486-3318-41fa-aaba-c48b5df75308"),
 *                 Map.entry("lastHeartbeatUtc", "2022-03-29T12:10:08.9167289Z"),
 *                 Map.entry("spnDetails", Map.ofEntries(
 *                     Map.entry("applicationId", "82b3e452-c0e8-4662-8347-58282925ae84"),
 *                     Map.entry("audience", "82b3e452-c0e8-4662-8347-58282925ae84"),
 *                     Map.entry("authority", "https://login.windows.net/72f988bf-86f1-41af-91ab-2d7cd011db47"),
 *                     Map.entry("objectId", "3fc89111-1405-4938-9214-37aa4739401d"),
 *                     Map.entry("tenantId", "72f988bf-86f1-41af-91ab-2d7cd011db47")
 *                 )),
 *                 Map.entry("version", "1.0.8.383")
 *             ))
 *             .discoverySiteId("/subscriptions/4bd2aa0f-2bd2-4d67-91a8-5a4533d58600/resourceGroups/ayagrawRG/providers/Microsoft.OffAzure/VMwareSites/Vmware2744site")
 *             .projectName("app18700project")
 *             .provisioningState("Succeeded")
 *             .resourceGroupName("ayagrawRG")
 *             .vmWareCollectorName("Vmware2258collector")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:migrate:VmwareCollectorsOperation Vmware2258collector /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/assessmentProjects/{projectName}/vmwarecollectors/{vmWareCollectorName}
 * ```
 */
public class VmwareCollectorsOperation internal constructor(
    override val javaResource: com.pulumi.azurenative.migrate.VmwareCollectorsOperation,
) : KotlinCustomResource(javaResource, VmwareCollectorsOperationMapper) {
    /**
     * Gets or sets the collector agent properties.
     */
    public val agentProperties: Output<CollectorAgentPropertiesBaseResponse>?
        get() = javaResource.agentProperties().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> collectorAgentPropertiesBaseResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Gets the Timestamp when collector was created.
     */
    public val createdTimestamp: Output<String>
        get() = javaResource.createdTimestamp().applyValue({ args0 -> args0 })

    /**
     * Gets the discovery site id.
     */
    public val discoverySiteId: Output<String>?
        get() = javaResource.discoverySiteId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The status of the last operation.
     */
    public val provisioningState: Output<String>?
        get() = javaResource.provisioningState().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Timestamp when collector was last updated.
     */
    public val updatedTimestamp: Output<String>
        get() = javaResource.updatedTimestamp().applyValue({ args0 -> args0 })
}

public object VmwareCollectorsOperationMapper : ResourceMapper<VmwareCollectorsOperation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.migrate.VmwareCollectorsOperation::class == javaResource::class

    override fun map(javaResource: Resource): VmwareCollectorsOperation =
        VmwareCollectorsOperation(
            javaResource as
                com.pulumi.azurenative.migrate.VmwareCollectorsOperation,
        )
}

/**
 * @see [VmwareCollectorsOperation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VmwareCollectorsOperation].
 */
public suspend fun vmwareCollectorsOperation(
    name: String,
    block: suspend VmwareCollectorsOperationResourceBuilder.() -> Unit,
): VmwareCollectorsOperation {
    val builder = VmwareCollectorsOperationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VmwareCollectorsOperation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun vmwareCollectorsOperation(name: String): VmwareCollectorsOperation {
    val builder = VmwareCollectorsOperationResourceBuilder()
    builder.name(name)
    return builder.build()
}
