@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin

import com.pulumi.azurenative.migrate.WorkloadDeploymentArgs.builder
import com.pulumi.azurenative.migrate.kotlin.inputs.WorkloadDeploymentModelPropertiesArgs
import com.pulumi.azurenative.migrate.kotlin.inputs.WorkloadDeploymentModelPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Workload deployment model.
 * Azure REST API version: 2022-05-01-preview.
 * ## Example Usage
 * ### WorkloadDeployment_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workloadDeployment = new AzureNative.Migrate.WorkloadDeployment("workloadDeployment", new()
 *     {
 *         ModernizeProjectName = "l6r8",
 *         Properties = new AzureNative.Migrate.Inputs.WorkloadDeploymentModelPropertiesArgs
 *         {
 *             CustomProperties =
 *             {
 *                 { "instanceType", "IISAKSWorkloadDeployment" },
 *             },
 *             DisplayName = "wqe",
 *             TargetPlatform = "AzureKubernetesService",
 *             WorkloadInstanceProperties = new AzureNative.Migrate.Inputs.WorkloadInstanceModelPropertiesArgs
 *             {
 *                 CustomProperties =
 *                 {
 *                     { "instanceType", "IISWorkload" },
 *                     { "webAppArmId", "xseseqsrzdiga" },
 *                     { "webAppSiteName", "mirgzmy" },
 *                 },
 *                 DisplayName = "juoorbubchvk",
 *                 MasterSiteName = "ubks",
 *                 MigrateAgentId = "aqgzsxqbk",
 *                 Name = "wonkuhgsafzviuwqerzdmme",
 *                 SourceName = "weuxcqzwpeyzsjhdgqflhxlwjhbz",
 *                 SourcePlatform = "eh",
 *             },
 *         },
 *         ResourceGroupName = "rgmigrateEngine",
 *         Tags =
 *         {
 *             { "key8241", "gcyxztzr" },
 *         },
 *         WorkloadDeploymentName = "l4t",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/migrate/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := migrate.NewWorkloadDeployment(ctx, "workloadDeployment", &migrate.WorkloadDeploymentArgs{
 * ModernizeProjectName: pulumi.String("l6r8"),
 * Properties: migrate.WorkloadDeploymentModelPropertiesResponse{
 * CustomProperties: interface{}{
 * InstanceType: pulumi.String("IISAKSWorkloadDeployment"),
 * },
 * DisplayName: pulumi.String("wqe"),
 * TargetPlatform: pulumi.String("AzureKubernetesService"),
 * WorkloadInstanceProperties: interface{}{
 * CustomProperties: interface{}{
 * InstanceType: pulumi.String("IISWorkload"),
 * WebAppArmId: pulumi.String("xseseqsrzdiga"),
 * WebAppSiteName: pulumi.String("mirgzmy"),
 * },
 * DisplayName: pulumi.String("juoorbubchvk"),
 * MasterSiteName: pulumi.String("ubks"),
 * MigrateAgentId: pulumi.String("aqgzsxqbk"),
 * Name: pulumi.String("wonkuhgsafzviuwqerzdmme"),
 * SourceName: pulumi.String("weuxcqzwpeyzsjhdgqflhxlwjhbz"),
 * SourcePlatform: pulumi.String("eh"),
 * },
 * },
 * ResourceGroupName: pulumi.String("rgmigrateEngine"),
 * Tags: pulumi.StringMap{
 * "key8241": pulumi.String("gcyxztzr"),
 * },
 * WorkloadDeploymentName: pulumi.String("l4t"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.migrate.WorkloadDeployment;
 * import com.pulumi.azurenative.migrate.WorkloadDeploymentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workloadDeployment = new WorkloadDeployment("workloadDeployment", WorkloadDeploymentArgs.builder()
 *             .modernizeProjectName("l6r8")
 *             .properties(Map.ofEntries(
 *                 Map.entry("customProperties", Map.of("instanceType", "IISAKSWorkloadDeployment")),
 *                 Map.entry("displayName", "wqe"),
 *                 Map.entry("targetPlatform", "AzureKubernetesService"),
 *                 Map.entry("workloadInstanceProperties", Map.ofEntries(
 *                     Map.entry("customProperties", Map.ofEntries(
 *                         Map.entry("instanceType", "IISWorkload"),
 *                         Map.entry("webAppArmId", "xseseqsrzdiga"),
 *                         Map.entry("webAppSiteName", "mirgzmy")
 *                     )),
 *                     Map.entry("displayName", "juoorbubchvk"),
 *                     Map.entry("masterSiteName", "ubks"),
 *                     Map.entry("migrateAgentId", "aqgzsxqbk"),
 *                     Map.entry("name", "wonkuhgsafzviuwqerzdmme"),
 *                     Map.entry("sourceName", "weuxcqzwpeyzsjhdgqflhxlwjhbz"),
 *                     Map.entry("sourcePlatform", "eh")
 *                 ))
 *             ))
 *             .resourceGroupName("rgmigrateEngine")
 *             .tags(Map.of("key8241", "gcyxztzr"))
 *             .workloadDeploymentName("l4t")
 *             .build());
 *     }
 * }
 * ```
 * ### WorkloadDeployment_Create_MinimumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workloadDeployment = new AzureNative.Migrate.WorkloadDeployment("workloadDeployment", new()
 *     {
 *         ModernizeProjectName = "tc",
 *         ResourceGroupName = "rgmigrateEngine",
 *         WorkloadDeploymentName = "wo2rs4",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/migrate/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := migrate.NewWorkloadDeployment(ctx, "workloadDeployment", &migrate.WorkloadDeploymentArgs{
 * 			ModernizeProjectName:   pulumi.String("tc"),
 * 			ResourceGroupName:      pulumi.String("rgmigrateEngine"),
 * 			WorkloadDeploymentName: pulumi.String("wo2rs4"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.migrate.WorkloadDeployment;
 * import com.pulumi.azurenative.migrate.WorkloadDeploymentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workloadDeployment = new WorkloadDeployment("workloadDeployment", WorkloadDeploymentArgs.builder()
 *             .modernizeProjectName("tc")
 *             .resourceGroupName("rgmigrateEngine")
 *             .workloadDeploymentName("wo2rs4")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:migrate:WorkloadDeployment obqwiueoajtezyusejl /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/modernizeProjects/{modernizeProjectName}/workloadDeployments/{workloadDeploymentName}
 * ```
 * @property modernizeProjectName ModernizeProject name.
 * @property properties Workload deployment model properties.
 * @property resourceGroupName Name of the Azure Resource Group that project is part of.
 * @property subscriptionId Azure Subscription Id in which project was created.
 * @property tags Gets or sets the resource tags.
 * @property workloadDeploymentName Workload deployment name.
 */
public data class WorkloadDeploymentArgs(
    public val modernizeProjectName: Output<String>? = null,
    public val properties: Output<WorkloadDeploymentModelPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val subscriptionId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val workloadDeploymentName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.WorkloadDeploymentArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.WorkloadDeploymentArgs =
        com.pulumi.azurenative.migrate.WorkloadDeploymentArgs.builder()
            .modernizeProjectName(modernizeProjectName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .subscriptionId(subscriptionId?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .workloadDeploymentName(workloadDeploymentName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WorkloadDeploymentArgs].
 */
@PulumiTagMarker
public class WorkloadDeploymentArgsBuilder internal constructor() {
    private var modernizeProjectName: Output<String>? = null

    private var properties: Output<WorkloadDeploymentModelPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var subscriptionId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var workloadDeploymentName: Output<String>? = null

    /**
     * @param value ModernizeProject name.
     */
    @JvmName("cgdihkgptgnjleki")
    public suspend fun modernizeProjectName(`value`: Output<String>) {
        this.modernizeProjectName = value
    }

    /**
     * @param value Workload deployment model properties.
     */
    @JvmName("quxrjinlfgghjjvh")
    public suspend fun properties(`value`: Output<WorkloadDeploymentModelPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value Name of the Azure Resource Group that project is part of.
     */
    @JvmName("ityskbbshslwhido")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Azure Subscription Id in which project was created.
     */
    @JvmName("kfqqnoxfycafgkya")
    public suspend fun subscriptionId(`value`: Output<String>) {
        this.subscriptionId = value
    }

    /**
     * @param value Gets or sets the resource tags.
     */
    @JvmName("dlmrhqqwaiglvxwa")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Workload deployment name.
     */
    @JvmName("psvwabjwwhfljqvx")
    public suspend fun workloadDeploymentName(`value`: Output<String>) {
        this.workloadDeploymentName = value
    }

    /**
     * @param value ModernizeProject name.
     */
    @JvmName("jjlbommoqmrpcmlf")
    public suspend fun modernizeProjectName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.modernizeProjectName = mapped
    }

    /**
     * @param value Workload deployment model properties.
     */
    @JvmName("tijpohoabofjyber")
    public suspend fun properties(`value`: WorkloadDeploymentModelPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Workload deployment model properties.
     */
    @JvmName("xokvybtrqcrsaorw")
    public suspend
    fun properties(argument: suspend WorkloadDeploymentModelPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = WorkloadDeploymentModelPropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value Name of the Azure Resource Group that project is part of.
     */
    @JvmName("lvnknygferagckif")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Azure Subscription Id in which project was created.
     */
    @JvmName("wcncqygtoapmsexk")
    public suspend fun subscriptionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subscriptionId = mapped
    }

    /**
     * @param value Gets or sets the resource tags.
     */
    @JvmName("fflhgfqxouvluvbb")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Gets or sets the resource tags.
     */
    @JvmName("hevmxeurvbxnfhfa")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Workload deployment name.
     */
    @JvmName("xucyqvqdcwtdaykj")
    public suspend fun workloadDeploymentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workloadDeploymentName = mapped
    }

    internal fun build(): WorkloadDeploymentArgs = WorkloadDeploymentArgs(
        modernizeProjectName = modernizeProjectName,
        properties = properties,
        resourceGroupName = resourceGroupName,
        subscriptionId = subscriptionId,
        tags = tags,
        workloadDeploymentName = workloadDeploymentName,
    )
}
