@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin

import com.pulumi.azurenative.migrate.WorkloadInstanceArgs.builder
import com.pulumi.azurenative.migrate.kotlin.inputs.WorkloadInstanceModelPropertiesArgs
import com.pulumi.azurenative.migrate.kotlin.inputs.WorkloadInstanceModelPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Workload instance model.
 * Azure REST API version: 2022-05-01-preview.
 * ## Example Usage
 * ### WorkloadInstance_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workloadInstance = new AzureNative.Migrate.WorkloadInstance("workloadInstance", new()
 *     {
 *         ModernizeProjectName = "mx8",
 *         Properties = new AzureNative.Migrate.Inputs.WorkloadInstanceModelPropertiesArgs
 *         {
 *             CustomProperties =
 *             {
 *                 { "instanceType", "IISWorkload" },
 *                 { "webAppArmId", "xseseqsrzdiga" },
 *                 { "webAppSiteName", "mirgzmy" },
 *             },
 *             DisplayName = "juoorbubchvk",
 *             MasterSiteName = "ubks",
 *             MigrateAgentId = "aqgzsxqbk",
 *             Name = "wonkuhgsafzviuwqerzdmme",
 *             SourceName = "weuxcqzwpeyzsjhdgqflhxlwjhbz",
 *             SourcePlatform = "eh",
 *         },
 *         ResourceGroupName = "rgmigrateEngine",
 *         Tags =
 *         {
 *             { "key2836", "biqip" },
 *         },
 *         WorkloadInstanceName = "m",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/migrate/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := migrate.NewWorkloadInstance(ctx, "workloadInstance", &migrate.WorkloadInstanceArgs{
 * ModernizeProjectName: pulumi.String("mx8"),
 * Properties: migrate.WorkloadInstanceModelPropertiesResponse{
 * CustomProperties: interface{}{
 * InstanceType: pulumi.String("IISWorkload"),
 * WebAppArmId: pulumi.String("xseseqsrzdiga"),
 * WebAppSiteName: pulumi.String("mirgzmy"),
 * },
 * DisplayName: pulumi.String("juoorbubchvk"),
 * MasterSiteName: pulumi.String("ubks"),
 * MigrateAgentId: pulumi.String("aqgzsxqbk"),
 * Name: pulumi.String("wonkuhgsafzviuwqerzdmme"),
 * SourceName: pulumi.String("weuxcqzwpeyzsjhdgqflhxlwjhbz"),
 * SourcePlatform: pulumi.String("eh"),
 * },
 * ResourceGroupName: pulumi.String("rgmigrateEngine"),
 * Tags: pulumi.StringMap{
 * "key2836": pulumi.String("biqip"),
 * },
 * WorkloadInstanceName: pulumi.String("m"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.migrate.WorkloadInstance;
 * import com.pulumi.azurenative.migrate.WorkloadInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workloadInstance = new WorkloadInstance("workloadInstance", WorkloadInstanceArgs.builder()
 *             .modernizeProjectName("mx8")
 *             .properties(Map.ofEntries(
 *                 Map.entry("customProperties", Map.ofEntries(
 *                     Map.entry("instanceType", "IISWorkload"),
 *                     Map.entry("webAppArmId", "xseseqsrzdiga"),
 *                     Map.entry("webAppSiteName", "mirgzmy")
 *                 )),
 *                 Map.entry("displayName", "juoorbubchvk"),
 *                 Map.entry("masterSiteName", "ubks"),
 *                 Map.entry("migrateAgentId", "aqgzsxqbk"),
 *                 Map.entry("name", "wonkuhgsafzviuwqerzdmme"),
 *                 Map.entry("sourceName", "weuxcqzwpeyzsjhdgqflhxlwjhbz"),
 *                 Map.entry("sourcePlatform", "eh")
 *             ))
 *             .resourceGroupName("rgmigrateEngine")
 *             .tags(Map.of("key2836", "biqip"))
 *             .workloadInstanceName("m")
 *             .build());
 *     }
 * }
 * ```
 * ### WorkloadInstance_Create_MinimumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workloadInstance = new AzureNative.Migrate.WorkloadInstance("workloadInstance", new()
 *     {
 *         ModernizeProjectName = "tv39",
 *         ResourceGroupName = "rgmigrateEngine",
 *         WorkloadInstanceName = "io",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/migrate/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := migrate.NewWorkloadInstance(ctx, "workloadInstance", &migrate.WorkloadInstanceArgs{
 * 			ModernizeProjectName: pulumi.String("tv39"),
 * 			ResourceGroupName:    pulumi.String("rgmigrateEngine"),
 * 			WorkloadInstanceName: pulumi.String("io"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.migrate.WorkloadInstance;
 * import com.pulumi.azurenative.migrate.WorkloadInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workloadInstance = new WorkloadInstance("workloadInstance", WorkloadInstanceArgs.builder()
 *             .modernizeProjectName("tv39")
 *             .resourceGroupName("rgmigrateEngine")
 *             .workloadInstanceName("io")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:migrate:WorkloadInstance piu /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/modernizeProjects/{modernizeProjectName}/workloadInstances/{workloadInstanceName}
 * ```
 * @property modernizeProjectName ModernizeProject name.
 * @property properties Workload instance model properties.
 * @property resourceGroupName Name of the Azure Resource Group that project is part of.
 * @property subscriptionId Azure Subscription Id in which project was created.
 * @property tags Gets or sets the resource tags.
 * @property workloadInstanceName Workload instance name.
 */
public data class WorkloadInstanceArgs(
    public val modernizeProjectName: Output<String>? = null,
    public val properties: Output<WorkloadInstanceModelPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val subscriptionId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val workloadInstanceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.WorkloadInstanceArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.WorkloadInstanceArgs =
        com.pulumi.azurenative.migrate.WorkloadInstanceArgs.builder()
            .modernizeProjectName(modernizeProjectName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .subscriptionId(subscriptionId?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .workloadInstanceName(workloadInstanceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WorkloadInstanceArgs].
 */
@PulumiTagMarker
public class WorkloadInstanceArgsBuilder internal constructor() {
    private var modernizeProjectName: Output<String>? = null

    private var properties: Output<WorkloadInstanceModelPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var subscriptionId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var workloadInstanceName: Output<String>? = null

    /**
     * @param value ModernizeProject name.
     */
    @JvmName("dhlnpkssdpuypbcq")
    public suspend fun modernizeProjectName(`value`: Output<String>) {
        this.modernizeProjectName = value
    }

    /**
     * @param value Workload instance model properties.
     */
    @JvmName("wnglwbenkjpwsjso")
    public suspend fun properties(`value`: Output<WorkloadInstanceModelPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value Name of the Azure Resource Group that project is part of.
     */
    @JvmName("okoynncjtptbctim")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Azure Subscription Id in which project was created.
     */
    @JvmName("uverbrmtheqhvkeb")
    public suspend fun subscriptionId(`value`: Output<String>) {
        this.subscriptionId = value
    }

    /**
     * @param value Gets or sets the resource tags.
     */
    @JvmName("efmrosjrihufipew")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Workload instance name.
     */
    @JvmName("ctwjasqomrlagndu")
    public suspend fun workloadInstanceName(`value`: Output<String>) {
        this.workloadInstanceName = value
    }

    /**
     * @param value ModernizeProject name.
     */
    @JvmName("pcvekmwcxmraxoyv")
    public suspend fun modernizeProjectName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.modernizeProjectName = mapped
    }

    /**
     * @param value Workload instance model properties.
     */
    @JvmName("bvqjhnocafussffo")
    public suspend fun properties(`value`: WorkloadInstanceModelPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Workload instance model properties.
     */
    @JvmName("yfmwwadacggdbyds")
    public suspend
    fun properties(argument: suspend WorkloadInstanceModelPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = WorkloadInstanceModelPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value Name of the Azure Resource Group that project is part of.
     */
    @JvmName("xdiitpepxuhduahk")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Azure Subscription Id in which project was created.
     */
    @JvmName("fqwdjljaaurgqcyw")
    public suspend fun subscriptionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subscriptionId = mapped
    }

    /**
     * @param value Gets or sets the resource tags.
     */
    @JvmName("kpyanctxawxnnpuv")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Gets or sets the resource tags.
     */
    @JvmName("eforgacsonmfpbxd")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Workload instance name.
     */
    @JvmName("isymphfbsqqmusyn")
    public suspend fun workloadInstanceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workloadInstanceName = mapped
    }

    internal fun build(): WorkloadInstanceArgs = WorkloadInstanceArgs(
        modernizeProjectName = modernizeProjectName,
        properties = properties,
        resourceGroupName = resourceGroupName,
        subscriptionId = subscriptionId,
        tags = tags,
        workloadInstanceName = workloadInstanceName,
    )
}
