@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Gets or sets the cleanup state of the solution.
 */
public enum class CleanupState(
    public val javaValue: com.pulumi.azurenative.migrate.enums.CleanupState,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.enums.CleanupState> {
    None(com.pulumi.azurenative.migrate.enums.CleanupState.None),
    Started(com.pulumi.azurenative.migrate.enums.CleanupState.Started),
    InProgress(com.pulumi.azurenative.migrate.enums.CleanupState.InProgress),
    Completed(com.pulumi.azurenative.migrate.enums.CleanupState.Completed),
    Failed(com.pulumi.azurenative.migrate.enums.CleanupState.Failed),
    ;

    override fun toJava(): com.pulumi.azurenative.migrate.enums.CleanupState = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.enums.CleanupState): CleanupState =
            CleanupState.values().first { it.javaValue == javaType }
    }
}
