@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Percentile of the utilization data values to be considered while assessing
 * machines.
 */
public enum class Percentile(
    public val javaValue: com.pulumi.azurenative.migrate.enums.Percentile,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.enums.Percentile> {
    Percentile50(com.pulumi.azurenative.migrate.enums.Percentile.Percentile50),
    Percentile90(com.pulumi.azurenative.migrate.enums.Percentile.Percentile90),
    Percentile95(com.pulumi.azurenative.migrate.enums.Percentile.Percentile95),
    Percentile99(com.pulumi.azurenative.migrate.enums.Percentile.Percentile99),
    ;

    override fun toJava(): com.pulumi.azurenative.migrate.enums.Percentile = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.enums.Percentile): Percentile =
            Percentile.values().first { it.javaValue == javaType }
    }
}
