@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The status of the last operation.
 */
public enum class ProvisioningState(
    public val javaValue: com.pulumi.azurenative.migrate.enums.ProvisioningState,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.enums.ProvisioningState> {
    /**
     * Resource has been created.
     */
    Succeeded(com.pulumi.azurenative.migrate.enums.ProvisioningState.Succeeded),

    /**
     * Resource creation failed.
     */
    Failed(com.pulumi.azurenative.migrate.enums.ProvisioningState.Failed),

    /**
     * Resource creation was canceled.
     */
    Canceled(com.pulumi.azurenative.migrate.enums.ProvisioningState.Canceled),

    /**
     * Resource is being Provisioned.
     */
    Provisioning(com.pulumi.azurenative.migrate.enums.ProvisioningState.Provisioning),

    /**
     * Resource is being Updated.
     */
    Updating(com.pulumi.azurenative.migrate.enums.ProvisioningState.Updating),

    /**
     * Resource is being Deleted.
     */
    Deleting(com.pulumi.azurenative.migrate.enums.ProvisioningState.Deleting),

    /**
     * Resource is being Accepted.
     */
    Accepted(com.pulumi.azurenative.migrate.enums.ProvisioningState.Accepted),
    ;

    override fun toJava(): com.pulumi.azurenative.migrate.enums.ProvisioningState = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.enums.ProvisioningState):
            ProvisioningState = ProvisioningState.values().first { it.javaValue == javaType }
    }
}
