@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

public enum class SecretStoreType(
    public val javaValue: com.pulumi.azurenative.migrate.enums.SecretStoreType,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.enums.SecretStoreType> {
    None(com.pulumi.azurenative.migrate.enums.SecretStoreType.None),
    KubeSecret(com.pulumi.azurenative.migrate.enums.SecretStoreType.KubeSecret),
    KeyVaultSecret(com.pulumi.azurenative.migrate.enums.SecretStoreType.KeyVaultSecret),
    AppServiceAppSettings(com.pulumi.azurenative.migrate.enums.SecretStoreType.AppServiceAppSettings),
    ;

    override fun toJava(): com.pulumi.azurenative.migrate.enums.SecretStoreType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.enums.SecretStoreType):
            SecretStoreType = SecretStoreType.values().first { it.javaValue == javaType }
    }
}
