@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.ApacheTomcatWorkloadInstanceModelCustomPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * ApacheTomcat workload instance model custom properties.
 * @property apacheTomcatWebApplication ApacheTomcat web application.
 * @property instanceType Gets or sets the instance type.
 * Expected value is 'ApacheTomcatWorkloadInstanceModelCustomProperties'.
 * @property webAppArmId Gets or sets the Web application ARM id.
 * @property webAppSiteName Gets or sets the Web application site name.
 */
public data class ApacheTomcatWorkloadInstanceModelCustomPropertiesArgs(
    public val apacheTomcatWebApplication: Output<ApacheTomcatWebApplicationArgs>? = null,
    public val instanceType: Output<String>,
    public val webAppArmId: Output<String>? = null,
    public val webAppSiteName: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.ApacheTomcatWorkloadInstanceModelCustomPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.migrate.inputs.ApacheTomcatWorkloadInstanceModelCustomPropertiesArgs =
        com.pulumi.azurenative.migrate.inputs.ApacheTomcatWorkloadInstanceModelCustomPropertiesArgs.builder()
            .apacheTomcatWebApplication(
                apacheTomcatWebApplication?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .instanceType(instanceType.applyValue({ args0 -> args0 }))
            .webAppArmId(webAppArmId?.applyValue({ args0 -> args0 }))
            .webAppSiteName(webAppSiteName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApacheTomcatWorkloadInstanceModelCustomPropertiesArgs].
 */
@PulumiTagMarker
public class ApacheTomcatWorkloadInstanceModelCustomPropertiesArgsBuilder internal constructor() {
    private var apacheTomcatWebApplication: Output<ApacheTomcatWebApplicationArgs>? = null

    private var instanceType: Output<String>? = null

    private var webAppArmId: Output<String>? = null

    private var webAppSiteName: Output<String>? = null

    /**
     * @param value ApacheTomcat web application.
     */
    @JvmName("fdjkqfwqqqpxklhs")
    public suspend fun apacheTomcatWebApplication(`value`: Output<ApacheTomcatWebApplicationArgs>) {
        this.apacheTomcatWebApplication = value
    }

    /**
     * @param value Gets or sets the instance type.
     * Expected value is 'ApacheTomcatWorkloadInstanceModelCustomProperties'.
     */
    @JvmName("ggjldsywjqwamwil")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value Gets or sets the Web application ARM id.
     */
    @JvmName("vcemuomlmvauhxki")
    public suspend fun webAppArmId(`value`: Output<String>) {
        this.webAppArmId = value
    }

    /**
     * @param value Gets or sets the Web application site name.
     */
    @JvmName("qljklwvdvymfkhkk")
    public suspend fun webAppSiteName(`value`: Output<String>) {
        this.webAppSiteName = value
    }

    /**
     * @param value ApacheTomcat web application.
     */
    @JvmName("ifrmtyaacfqixgrb")
    public suspend fun apacheTomcatWebApplication(`value`: ApacheTomcatWebApplicationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apacheTomcatWebApplication = mapped
    }

    /**
     * @param argument ApacheTomcat web application.
     */
    @JvmName("qaenjlpgxybltbva")
    public suspend
    fun apacheTomcatWebApplication(argument: suspend ApacheTomcatWebApplicationArgsBuilder.() -> Unit) {
        val toBeMapped = ApacheTomcatWebApplicationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.apacheTomcatWebApplication = mapped
    }

    /**
     * @param value Gets or sets the instance type.
     * Expected value is 'ApacheTomcatWorkloadInstanceModelCustomProperties'.
     */
    @JvmName("frogvnlgiptnbklf")
    public suspend fun instanceType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    /**
     * @param value Gets or sets the Web application ARM id.
     */
    @JvmName("lwxocfvleoomybqo")
    public suspend fun webAppArmId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.webAppArmId = mapped
    }

    /**
     * @param value Gets or sets the Web application site name.
     */
    @JvmName("cuvkvvxxvawvhxlb")
    public suspend fun webAppSiteName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.webAppSiteName = mapped
    }

    internal fun build(): ApacheTomcatWorkloadInstanceModelCustomPropertiesArgs =
        ApacheTomcatWorkloadInstanceModelCustomPropertiesArgs(
            apacheTomcatWebApplication = apacheTomcatWebApplication,
            instanceType = instanceType ?: throw PulumiNullFieldException("instanceType"),
            webAppArmId = webAppArmId,
            webAppSiteName = webAppSiteName,
        )
}
