@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.CollectorBodyAgentSpnPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property applicationId Application/client Id for the service principal with which the on-premise management/data plane components would communicate with our Azure services.
 * @property audience Intended audience for the service principal.
 * @property authority AAD Authority URL which was used to request the token for the service principal.
 * @property objectId Object Id of the service principal with which the on-premise management/data plane components would communicate with our Azure services.
 * @property tenantId Tenant Id for the service principal with which the on-premise management/data plane components would communicate with our Azure services.
 */
public data class CollectorBodyAgentSpnPropertiesArgs(
    public val applicationId: Output<String>? = null,
    public val audience: Output<String>? = null,
    public val authority: Output<String>? = null,
    public val objectId: Output<String>? = null,
    public val tenantId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.CollectorBodyAgentSpnPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.CollectorBodyAgentSpnPropertiesArgs =
        com.pulumi.azurenative.migrate.inputs.CollectorBodyAgentSpnPropertiesArgs.builder()
            .applicationId(applicationId?.applyValue({ args0 -> args0 }))
            .audience(audience?.applyValue({ args0 -> args0 }))
            .authority(authority?.applyValue({ args0 -> args0 }))
            .objectId(objectId?.applyValue({ args0 -> args0 }))
            .tenantId(tenantId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CollectorBodyAgentSpnPropertiesArgs].
 */
@PulumiTagMarker
public class CollectorBodyAgentSpnPropertiesArgsBuilder internal constructor() {
    private var applicationId: Output<String>? = null

    private var audience: Output<String>? = null

    private var authority: Output<String>? = null

    private var objectId: Output<String>? = null

    private var tenantId: Output<String>? = null

    /**
     * @param value Application/client Id for the service principal with which the on-premise management/data plane components would communicate with our Azure services.
     */
    @JvmName("wqwmqlwhsiylamdg")
    public suspend fun applicationId(`value`: Output<String>) {
        this.applicationId = value
    }

    /**
     * @param value Intended audience for the service principal.
     */
    @JvmName("xxfrdfwktldrxvxq")
    public suspend fun audience(`value`: Output<String>) {
        this.audience = value
    }

    /**
     * @param value AAD Authority URL which was used to request the token for the service principal.
     */
    @JvmName("cijfietuxhjlidkw")
    public suspend fun authority(`value`: Output<String>) {
        this.authority = value
    }

    /**
     * @param value Object Id of the service principal with which the on-premise management/data plane components would communicate with our Azure services.
     */
    @JvmName("cbwkqgpibogsnlta")
    public suspend fun objectId(`value`: Output<String>) {
        this.objectId = value
    }

    /**
     * @param value Tenant Id for the service principal with which the on-premise management/data plane components would communicate with our Azure services.
     */
    @JvmName("ojlupypvnverjvbs")
    public suspend fun tenantId(`value`: Output<String>) {
        this.tenantId = value
    }

    /**
     * @param value Application/client Id for the service principal with which the on-premise management/data plane components would communicate with our Azure services.
     */
    @JvmName("tleugapikgihppdy")
    public suspend fun applicationId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationId = mapped
    }

    /**
     * @param value Intended audience for the service principal.
     */
    @JvmName("bjxtdepqgfhofbqm")
    public suspend fun audience(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.audience = mapped
    }

    /**
     * @param value AAD Authority URL which was used to request the token for the service principal.
     */
    @JvmName("fwgkecteabhyqxeg")
    public suspend fun authority(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authority = mapped
    }

    /**
     * @param value Object Id of the service principal with which the on-premise management/data plane components would communicate with our Azure services.
     */
    @JvmName("xsbmmgtuuflamcmf")
    public suspend fun objectId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.objectId = mapped
    }

    /**
     * @param value Tenant Id for the service principal with which the on-premise management/data plane components would communicate with our Azure services.
     */
    @JvmName("vxptbrocwpeapiqy")
    public suspend fun tenantId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tenantId = mapped
    }

    internal fun build(): CollectorBodyAgentSpnPropertiesArgs = CollectorBodyAgentSpnPropertiesArgs(
        applicationId = applicationId,
        audience = audience,
        authority = authority,
        objectId = objectId,
        tenantId = tenantId,
    )
}
