@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.ConnectionStateRequestBodyPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Properties of Connection state request.
 * @property privateLinkServiceConnectionState Private endpoint connection state.
 */
public data class ConnectionStateRequestBodyPropertiesArgs(
    public val privateLinkServiceConnectionState: Output<PrivateLinkServiceConnectionStateArgs>? =
        null,
) :
    ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.ConnectionStateRequestBodyPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.migrate.inputs.ConnectionStateRequestBodyPropertiesArgs =
        com.pulumi.azurenative.migrate.inputs.ConnectionStateRequestBodyPropertiesArgs.builder()
            .privateLinkServiceConnectionState(
                privateLinkServiceConnectionState?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            ).build()
}

/**
 * Builder for [ConnectionStateRequestBodyPropertiesArgs].
 */
@PulumiTagMarker
public class ConnectionStateRequestBodyPropertiesArgsBuilder internal constructor() {
    private var privateLinkServiceConnectionState: Output<PrivateLinkServiceConnectionStateArgs>? =
        null

    /**
     * @param value Private endpoint connection state.
     */
    @JvmName("rftbveajdiawqrrj")
    public suspend
    fun privateLinkServiceConnectionState(`value`: Output<PrivateLinkServiceConnectionStateArgs>) {
        this.privateLinkServiceConnectionState = value
    }

    /**
     * @param value Private endpoint connection state.
     */
    @JvmName("bdykgjrtymfnyyjc")
    public suspend
    fun privateLinkServiceConnectionState(`value`: PrivateLinkServiceConnectionStateArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateLinkServiceConnectionState = mapped
    }

    /**
     * @param argument Private endpoint connection state.
     */
    @JvmName("uviymxupgnysyfku")
    public suspend
    fun privateLinkServiceConnectionState(argument: suspend PrivateLinkServiceConnectionStateArgsBuilder.() -> Unit) {
        val toBeMapped = PrivateLinkServiceConnectionStateArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.privateLinkServiceConnectionState = mapped
    }

    internal fun build(): ConnectionStateRequestBodyPropertiesArgs =
        ConnectionStateRequestBodyPropertiesArgs(
            privateLinkServiceConnectionState = privateLinkServiceConnectionState,
        )
}
