@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.ContainerImagePropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Class for container image properties.
 * @property dockerfile Gets or sets the dockerfile for the container image.
 * @property imageName Gets or sets the container image name.
 * @property imageTag Gets or sets the container image tag.
 * @property registryProperties Class for ACR Properties.
 * @property runId Gets or sets the RunId.
 * @property runStatus Gets or sets the RunStatus.
 */
public data class ContainerImagePropertiesArgs(
    public val dockerfile: Output<String>? = null,
    public val imageName: Output<String>? = null,
    public val imageTag: Output<String>? = null,
    public val registryProperties: Output<ACRPropertiesArgs>? = null,
    public val runId: Output<String>? = null,
    public val runStatus: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.ContainerImagePropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.ContainerImagePropertiesArgs =
        com.pulumi.azurenative.migrate.inputs.ContainerImagePropertiesArgs.builder()
            .dockerfile(dockerfile?.applyValue({ args0 -> args0 }))
            .imageName(imageName?.applyValue({ args0 -> args0 }))
            .imageTag(imageTag?.applyValue({ args0 -> args0 }))
            .registryProperties(
                registryProperties?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .runId(runId?.applyValue({ args0 -> args0 }))
            .runStatus(runStatus?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ContainerImagePropertiesArgs].
 */
@PulumiTagMarker
public class ContainerImagePropertiesArgsBuilder internal constructor() {
    private var dockerfile: Output<String>? = null

    private var imageName: Output<String>? = null

    private var imageTag: Output<String>? = null

    private var registryProperties: Output<ACRPropertiesArgs>? = null

    private var runId: Output<String>? = null

    private var runStatus: Output<String>? = null

    /**
     * @param value Gets or sets the dockerfile for the container image.
     */
    @JvmName("shhwfbcacgxuuicm")
    public suspend fun dockerfile(`value`: Output<String>) {
        this.dockerfile = value
    }

    /**
     * @param value Gets or sets the container image name.
     */
    @JvmName("eyphhgdhlyycmqtk")
    public suspend fun imageName(`value`: Output<String>) {
        this.imageName = value
    }

    /**
     * @param value Gets or sets the container image tag.
     */
    @JvmName("kvysaqodljbrxrks")
    public suspend fun imageTag(`value`: Output<String>) {
        this.imageTag = value
    }

    /**
     * @param value Class for ACR Properties.
     */
    @JvmName("emamcxkynbfwdefy")
    public suspend fun registryProperties(`value`: Output<ACRPropertiesArgs>) {
        this.registryProperties = value
    }

    /**
     * @param value Gets or sets the RunId.
     */
    @JvmName("qwhwcwijpnqvrros")
    public suspend fun runId(`value`: Output<String>) {
        this.runId = value
    }

    /**
     * @param value Gets or sets the RunStatus.
     */
    @JvmName("vvwaiwnejrbisgke")
    public suspend fun runStatus(`value`: Output<String>) {
        this.runStatus = value
    }

    /**
     * @param value Gets or sets the dockerfile for the container image.
     */
    @JvmName("uxsavfllhpwmwssh")
    public suspend fun dockerfile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dockerfile = mapped
    }

    /**
     * @param value Gets or sets the container image name.
     */
    @JvmName("fprrllijndftumtu")
    public suspend fun imageName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageName = mapped
    }

    /**
     * @param value Gets or sets the container image tag.
     */
    @JvmName("gmlrmdcdprycfcvk")
    public suspend fun imageTag(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageTag = mapped
    }

    /**
     * @param value Class for ACR Properties.
     */
    @JvmName("wpbsdrggurdsawri")
    public suspend fun registryProperties(`value`: ACRPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.registryProperties = mapped
    }

    /**
     * @param argument Class for ACR Properties.
     */
    @JvmName("rrxvictupqkojent")
    public suspend fun registryProperties(argument: suspend ACRPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = ACRPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.registryProperties = mapped
    }

    /**
     * @param value Gets or sets the RunId.
     */
    @JvmName("lliopnjugoyorhug")
    public suspend fun runId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.runId = mapped
    }

    /**
     * @param value Gets or sets the RunStatus.
     */
    @JvmName("guqbticnmftayrik")
    public suspend fun runStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.runStatus = mapped
    }

    internal fun build(): ContainerImagePropertiesArgs = ContainerImagePropertiesArgs(
        dockerfile = dockerfile,
        imageName = imageName,
        imageTag = imageTag,
        registryProperties = registryProperties,
        runId = runId,
        runStatus = runStatus,
    )
}
